/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import me.forseth11.easybackup.dependencies.cronutils.mapper.CronMapper;
import me.forseth11.easybackup.dependencies.cronutils.model.Cron;
import me.forseth11.easybackup.dependencies.cronutils.model.definition.CronConstraint;
import me.forseth11.easybackup.dependencies.cronutils.model.definition.CronDefinition;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronField;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronFieldName;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.visitor.ValidationFieldExpressionVisitor;
import me.forseth11.easybackup.dependencies.cronutils.utils.Preconditions;

public class SingleCron
implements Cron {
    private static final long serialVersionUID = 7487370826825439098L;
    private final CronDefinition cronDefinition;
    private final Map<CronFieldName, CronField> fields;
    private String asString;

    public SingleCron(CronDefinition cronDefinition, List<CronField> list) {
        this.cronDefinition = Preconditions.checkNotNull(cronDefinition, "CronDefinition must not be null");
        Preconditions.checkNotNull(list, "CronFields cannot be null");
        this.fields = new EnumMap<CronFieldName, CronField>(CronFieldName.class);
        for (CronField cronField : list) {
            this.fields.put(cronField.getField(), cronField);
        }
    }

    @Override
    public CronField retrieve(CronFieldName cronFieldName) {
        return this.fields.get((Object)Preconditions.checkNotNull(cronFieldName, "CronFieldName must not be null"));
    }

    @Override
    public Map<CronFieldName, CronField> retrieveFieldsAsMap() {
        return Collections.unmodifiableMap(this.fields);
    }

    @Override
    public String asString() {
        if (this.asString == null) {
            ArrayList<CronField> arrayList = new ArrayList<CronField>(this.fields.values());
            arrayList.sort(CronField.createFieldComparator());
            StringBuilder stringBuilder = new StringBuilder();
            for (CronField cronField : arrayList) {
                stringBuilder.append(String.format("%s ", cronField.getExpression().asString()));
            }
            this.asString = stringBuilder.toString().trim();
        }
        return this.asString;
    }

    @Override
    public CronDefinition getCronDefinition() {
        return this.cronDefinition;
    }

    @Override
    public Cron validate() {
        for (Map.Entry<CronFieldName, CronField> object : this.retrieveFieldsAsMap().entrySet()) {
            CronFieldName cronFieldName = object.getKey();
            object.getValue().getExpression().accept(new ValidationFieldExpressionVisitor(this.getCronDefinition().getFieldDefinition(cronFieldName).getConstraints()));
        }
        for (CronConstraint cronConstraint : this.getCronDefinition().getCronConstraints()) {
            if (cronConstraint.validate(this)) continue;
            throw new IllegalArgumentException(String.format("Invalid cron expression: %s. %s", this.asString(), cronConstraint.getDescription()));
        }
        return this;
    }

    @Override
    public boolean equivalent(CronMapper cronMapper, Cron cron) {
        return this.asString().equals(cronMapper.map(cron).asString());
    }

    @Override
    public boolean equivalent(Cron cron) {
        return this.asString().equals(cron.asString());
    }
}

