/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.model.field.expression;

import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.FieldExpression;
import me.forseth11.easybackup.dependencies.cronutils.model.field.value.IntegerFieldValue;
import me.forseth11.easybackup.dependencies.cronutils.model.field.value.SpecialChar;
import me.forseth11.easybackup.dependencies.cronutils.model.field.value.SpecialCharFieldValue;
import me.forseth11.easybackup.dependencies.cronutils.utils.Preconditions;

public class On
extends FieldExpression {
    private static final long serialVersionUID = 8746471281123327324L;
    private static final int DEFAULT_NTH_VALUE = -1;
    private final IntegerFieldValue time;
    private final IntegerFieldValue nth;
    private final SpecialCharFieldValue specialChar;

    public On(SpecialCharFieldValue specialCharFieldValue) {
        this(new IntegerFieldValue(-1), specialCharFieldValue);
    }

    public On(IntegerFieldValue integerFieldValue) {
        this(integerFieldValue, new SpecialCharFieldValue(SpecialChar.NONE));
    }

    public On(IntegerFieldValue integerFieldValue, SpecialCharFieldValue specialCharFieldValue) {
        this(integerFieldValue, specialCharFieldValue, new IntegerFieldValue(-1));
        Preconditions.checkArgument(!specialCharFieldValue.getValue().equals((Object)SpecialChar.HASH), "value missing for a#b cron expression");
    }

    public On(IntegerFieldValue integerFieldValue, SpecialCharFieldValue specialCharFieldValue, IntegerFieldValue integerFieldValue2) {
        Preconditions.checkNotNull(integerFieldValue, "time must not be null");
        Preconditions.checkNotNull(specialCharFieldValue, "special char must not null");
        Preconditions.checkNotNull(integerFieldValue2, "nth value must not be null");
        this.time = integerFieldValue;
        this.specialChar = specialCharFieldValue;
        this.nth = integerFieldValue2;
    }

    public IntegerFieldValue getTime() {
        return this.time;
    }

    public IntegerFieldValue getNth() {
        return this.nth;
    }

    public SpecialCharFieldValue getSpecialChar() {
        return this.specialChar;
    }

    @Override
    public String asString() {
        switch (this.specialChar.getValue()) {
            case NONE: {
                return this.getTime().toString();
            }
            case HASH: {
                return String.format("%s#%s", this.getTime(), this.getNth());
            }
            case W: {
                return this.isDefault(this.getTime()) ? "W" : String.format("%sW", this.getTime());
            }
            case L: {
                return this.isDefault(this.getTime()) ? "L" + this.getNthStringRepresentation() : String.format("%sL", this.getTime());
            }
        }
        return this.specialChar.toString();
    }

    private String getNthStringRepresentation() {
        return this.isDefault(this.getNth()) ? "" : String.format("-%s", this.getNth());
    }

    private boolean isDefault(IntegerFieldValue integerFieldValue) {
        return integerFieldValue.getValue() == -1;
    }
}

