/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.model.time;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.forseth11.easybackup.dependencies.cronutils.model.time.ExecutionTime;
import me.forseth11.easybackup.dependencies.cronutils.utils.Preconditions;

public class CompositeExecutionTime
implements ExecutionTime {
    private final List<ExecutionTime> executionTimes;

    public CompositeExecutionTime(List<ExecutionTime> list) {
        Preconditions.checkNotNullNorEmpty(list, (Object)"ExecutionTime list cannot be null or empty");
        this.executionTimes = Collections.unmodifiableList(list);
    }

    @Override
    public Optional<ZonedDateTime> nextExecution(ZonedDateTime zonedDateTime) {
        Optional<Optional> optional3 = this.executionTimes.parallelStream().map(executionTime -> executionTime.nextExecution(zonedDateTime)).filter(Optional::isPresent).sorted((optional, optional2) -> {
            if (optional.isPresent() && optional2.isPresent()) {
                ZonedDateTime zonedDateTime = (ZonedDateTime)optional.get();
                ZonedDateTime zonedDateTime2 = (ZonedDateTime)optional2.get();
                return zonedDateTime.compareTo(zonedDateTime2);
            }
            return 0;
        }).findFirst();
        return optional3.orElseGet(Optional::empty);
    }

    @Override
    public Optional<Duration> timeToNextExecution(ZonedDateTime zonedDateTime) {
        Optional<ZonedDateTime> optional = this.nextExecution(zonedDateTime);
        return optional.map(zonedDateTime2 -> Duration.between(zonedDateTime, zonedDateTime2));
    }

    @Override
    public Optional<ZonedDateTime> lastExecution(ZonedDateTime zonedDateTime) {
        Optional<Optional> optional3 = this.executionTimes.parallelStream().map(executionTime -> executionTime.lastExecution(zonedDateTime)).filter(Optional::isPresent).sorted((optional, optional2) -> {
            if (optional.isPresent() && optional2.isPresent()) {
                ZonedDateTime zonedDateTime = (ZonedDateTime)optional.get();
                ZonedDateTime zonedDateTime2 = (ZonedDateTime)optional2.get();
                return zonedDateTime2.compareTo(zonedDateTime);
            }
            return 0;
        }).findFirst();
        return optional3.orElseGet(Optional::empty);
    }

    @Override
    public Optional<Duration> timeFromLastExecution(ZonedDateTime zonedDateTime) {
        return this.lastExecution(zonedDateTime).map(zonedDateTime2 -> Duration.between(zonedDateTime2, zonedDateTime));
    }

    @Override
    public boolean isMatch(ZonedDateTime zonedDateTime) {
        return this.executionTimes.parallelStream().map(executionTime -> executionTime.isMatch(zonedDateTime)).filter(bl2 -> bl2).count() > 0L;
    }
}

