/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.model.time;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import me.forseth11.easybackup.dependencies.cronutils.model.time.NearestValue;
import me.forseth11.easybackup.dependencies.cronutils.utils.Preconditions;
import me.forseth11.easybackup.dependencies.cronutils.utils.VisibleForTesting;

class TimeNode {
    protected List<Integer> values;

    public TimeNode(List<Integer> list) {
        this.values = Preconditions.checkNotNullNorEmpty(list, (Object)"Values must not be empty");
        Collections.sort(this.values);
    }

    public NearestValue getNextValue(int n2, int n3) {
        return this.getNearestForwardValue(n2, n3);
    }

    public List<Integer> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public NearestValue getPreviousValue(int n2, int n3) {
        return this.getNearestBackwardValue(n2, n3);
    }

    @VisibleForTesting
    NearestValue getNearestForwardValue(int n2, int n3) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.values);
        int n4 = 0;
        boolean bl2 = false;
        AtomicInteger atomicInteger = new AtomicInteger(0);
        if (!arrayList.contains(n2)) {
            for (Integer n5 : arrayList) {
                if (n5 <= n2) continue;
                n4 = arrayList.indexOf(n5);
                --n3;
                bl2 = true;
                break;
            }
            if (!bl2) {
                atomicInteger.incrementAndGet();
            }
        } else {
            n4 = arrayList.indexOf(n2);
        }
        int n6 = (Integer)arrayList.get(n4);
        for (int i2 = 0; i2 < n3; ++i2) {
            n6 = this.getValueFromList(arrayList, n4 + 1, atomicInteger);
            n4 = arrayList.indexOf(n6);
        }
        return new NearestValue(n6, atomicInteger.get());
    }

    @VisibleForTesting
    NearestValue getNearestBackwardValue(int n2, int n3) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.values);
        Collections.reverse(arrayList);
        int n4 = 0;
        boolean bl2 = false;
        AtomicInteger atomicInteger = new AtomicInteger(0);
        if (!arrayList.contains(n2)) {
            for (Integer n5 : arrayList) {
                if (n5 >= n2) continue;
                n4 = arrayList.indexOf(n5);
                --n3;
                bl2 = true;
                break;
            }
            if (!bl2) {
                atomicInteger.incrementAndGet();
            }
        } else {
            n4 = arrayList.indexOf(n2);
        }
        int n6 = (Integer)arrayList.get(n4);
        for (int i2 = 0; i2 < n3; ++i2) {
            n6 = this.getValueFromList(arrayList, n4 + 1, atomicInteger);
            n4 = arrayList.indexOf(n6);
        }
        return new NearestValue(n6, atomicInteger.get());
    }

    @VisibleForTesting
    int getValueFromList(List<Integer> list, int n2, AtomicInteger atomicInteger) {
        Preconditions.checkNotNullNorEmpty(list, (Object)"List must not be empty");
        if (n2 < 0) {
            atomicInteger.incrementAndGet();
            return this.getValueFromList(list, n2 += list.size(), atomicInteger);
        }
        if (n2 >= list.size()) {
            atomicInteger.incrementAndGet();
            return this.getValueFromList(list, n2 -= list.size(), atomicInteger);
        }
        return list.get(n2);
    }
}

