/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.model.time.generator;

import java.util.ArrayList;
import java.util.List;
import me.forseth11.easybackup.dependencies.cronutils.mapper.WeekDay;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronField;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronFieldName;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.And;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.FieldExpression;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.FieldValueGenerator;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.FieldValueGeneratorFactory;
import me.forseth11.easybackup.dependencies.cronutils.utils.Preconditions;

class AndDayOfWeekValueGenerator
extends FieldValueGenerator {
    private final int year;
    private final int month;
    private final WeekDay mondayDoWValue;

    public AndDayOfWeekValueGenerator(CronField cronField, int n2, int n3, WeekDay weekDay) {
        super(cronField);
        Preconditions.checkArgument(CronFieldName.DAY_OF_WEEK.equals((Object)cronField.getField()), "CronField does not belong to day of week");
        this.year = n2;
        this.month = n3;
        this.mondayDoWValue = weekDay;
    }

    @Override
    protected List<Integer> generateCandidatesNotIncludingIntervalExtremes(int n2, int n3) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        And and = (And)this.cronField.getExpression();
        for (FieldExpression fieldExpression : and.getExpressions()) {
            CronField cronField = new CronField(CronFieldName.DAY_OF_WEEK, fieldExpression, this.cronField.getConstraints());
            List<Integer> list = FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(cronField, this.year, this.month, this.mondayDoWValue).generateCandidates(n2, n3);
            if (list == null) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    @Override
    protected boolean matchesFieldExpressionClass(FieldExpression fieldExpression) {
        return fieldExpression instanceof And;
    }

    @Override
    public int generateNextValue(int n2) {
        return 0;
    }

    @Override
    public int generatePreviousValue(int n2) {
        return 0;
    }

    @Override
    public boolean isMatch(int n2) {
        return false;
    }
}

