/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.model.time.generator;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import me.forseth11.easybackup.dependencies.cronutils.mapper.WeekDay;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronField;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronFieldName;
import me.forseth11.easybackup.dependencies.cronutils.model.field.constraint.FieldConstraintsBuilder;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.Between;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.FieldExpression;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.FieldValueGenerator;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.OnDayOfWeekValueGenerator;
import me.forseth11.easybackup.dependencies.cronutils.parser.CronParserField;
import me.forseth11.easybackup.dependencies.cronutils.utils.Preconditions;

class BetweenDayOfWeekValueGenerator
extends FieldValueGenerator {
    private final int year;
    private final int month;
    private final WeekDay mondayDoWValue;
    private final Set<Integer> dowValidValues;

    public BetweenDayOfWeekValueGenerator(CronField cronField, int n2, int n3, WeekDay weekDay) {
        super(cronField);
        Preconditions.checkArgument(CronFieldName.DAY_OF_WEEK.equals((Object)cronField.getField()), "CronField does not belong to day of week");
        this.year = n2;
        this.month = n3;
        this.mondayDoWValue = weekDay;
        this.dowValidValues = new HashSet<Integer>();
        Between between = (Between)cronField.getExpression();
        int n4 = (Integer)between.getFrom().getValue();
        int n5 = (Integer)between.getTo().getValue();
        if (n5 >= n4) {
            IntStream.rangeClosed(n4, n5).forEach(this.dowValidValues::add);
        } else {
            IntStream.rangeClosed(n4, cronField.getConstraints().getEndRange()).forEach(this.dowValidValues::add);
            IntStream.rangeClosed(cronField.getConstraints().getStartRange(), n5).forEach(this.dowValidValues::add);
        }
    }

    @Override
    protected List<Integer> generateCandidatesNotIncludingIntervalExtremes(int n2, int n3) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Integer n4 : this.dowValidValues) {
            FieldConstraintsBuilder fieldConstraintsBuilder = FieldConstraintsBuilder.instance().forField(CronFieldName.DAY_OF_WEEK);
            CronParserField cronParserField = new CronParserField(CronFieldName.DAY_OF_WEEK, fieldConstraintsBuilder.createConstraintsInstance());
            CronField cronField = cronParserField.parse(n4.toString());
            OnDayOfWeekValueGenerator onDayOfWeekValueGenerator = new OnDayOfWeekValueGenerator(cronField, this.year, this.month, this.mondayDoWValue);
            List<Integer> list = onDayOfWeekValueGenerator.generateCandidates(n2, n3);
            if (list == null) continue;
            arrayList.addAll(list);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    @Override
    protected boolean matchesFieldExpressionClass(FieldExpression fieldExpression) {
        return fieldExpression instanceof Between;
    }

    @Override
    public int generateNextValue(int n2) {
        return 0;
    }

    @Override
    public int generatePreviousValue(int n2) {
        return 0;
    }

    @Override
    public boolean isMatch(int n2) {
        int n3 = LocalDate.of(this.year, this.month, n2).getDayOfWeek().getValue();
        int n4 = n3 % 7 + (this.mondayDoWValue.getMondayDoWValue() - 1);
        return this.dowValidValues.contains(n4);
    }
}

