/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.model.time.generator;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import me.forseth11.easybackup.dependencies.cronutils.mapper.ConstantsMapper;
import me.forseth11.easybackup.dependencies.cronutils.mapper.WeekDay;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronField;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronFieldName;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.Every;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.EveryFieldValueGenerator;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.NoSuchValueException;
import me.forseth11.easybackup.dependencies.cronutils.utils.Preconditions;

class EveryDayOfWeekValueGenerator
extends EveryFieldValueGenerator {
    private final int lastDayOfMonth;
    private final Set<DayOfWeek> dowValidValues;
    private final int year;
    private final int month;

    EveryDayOfWeekValueGenerator(CronField cronField, int n2, int n3, WeekDay weekDay) {
        super(cronField);
        Preconditions.checkArgument(CronFieldName.DAY_OF_WEEK.equals((Object)cronField.getField()), "CronField does not belong to day of week");
        this.year = n2;
        this.month = n3;
        LocalDate localDate = LocalDate.of(n2, n3, 1);
        this.lastDayOfMonth = localDate.lengthOfMonth();
        Every every = (Every)cronField.getExpression();
        int n4 = every.getPeriod().getValue();
        Preconditions.checkArgument(n4 > 0 && n4 < 8, "Cron Expression for day of week has an invalid period.");
        this.dowValidValues = EveryDayOfWeekValueGenerator.getValidDays(weekDay, n4, this.from, this.to);
    }

    private static Set<DayOfWeek> getValidDays(WeekDay weekDay, int n2, int n3, int n4) {
        ArrayList<DayOfWeek> arrayList = new ArrayList<DayOfWeek>(7);
        for (int i2 = n3; i2 <= n4; i2 += n2) {
            int n5 = ConstantsMapper.weekDayMapping(weekDay, ConstantsMapper.JAVA8, i2);
            arrayList.add(DayOfWeek.of(n5));
        }
        return EnumSet.copyOf(arrayList);
    }

    @Override
    public int generateNextValue(int n2) {
        int n3 = n2;
        while (!this.isMatch(++n3) && n3 <= this.lastDayOfMonth) {
        }
        if (n3 > this.lastDayOfMonth) {
            throw new NoSuchValueException();
        }
        return n3;
    }

    @Override
    public int generatePreviousValue(int n2) {
        int n3 = n2;
        while (!this.isMatch(--n3) && n3 > 0) {
        }
        if (n3 <= 0) {
            throw new NoSuchValueException();
        }
        return n3;
    }

    @Override
    protected List<Integer> generateCandidatesNotIncludingIntervalExtremes(int n2, int n3) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n4 = n2;
        try {
            while (n4 < n3) {
                if ((n4 = this.generateNextValue(n4)) >= n3) continue;
                arrayList.add(n4);
            }
        }
        catch (NoSuchValueException noSuchValueException) {
            // empty catch block
        }
        return arrayList;
    }

    @Override
    public boolean isMatch(int n2) {
        if (n2 > this.lastDayOfMonth || n2 < 1) {
            return false;
        }
        DayOfWeek dayOfWeek = LocalDate.of(this.year, this.month, n2).getDayOfWeek();
        return this.dowValidValues.contains(dayOfWeek);
    }
}

