/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.model.time.generator;

import java.time.DayOfWeek;
import java.time.LocalDate;
import me.forseth11.easybackup.dependencies.cronutils.mapper.ConstantsMapper;
import me.forseth11.easybackup.dependencies.cronutils.mapper.WeekDay;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronField;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronFieldName;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.FieldExpression;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.On;
import me.forseth11.easybackup.dependencies.cronutils.model.field.value.IntegerFieldValue;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.NoSuchValueException;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.OnDayOfCalendarValueGenerator;
import me.forseth11.easybackup.dependencies.cronutils.utils.Preconditions;

class OnDayOfWeekValueGenerator
extends OnDayOfCalendarValueGenerator {
    private static final On ON_SATURDAY = new On(new IntegerFieldValue(7));
    private final WeekDay mondayDoWValue;

    public OnDayOfWeekValueGenerator(CronField cronField, int n2, int n3, WeekDay weekDay) {
        super(cronField, n2, n3);
        Preconditions.checkArgument(CronFieldName.DAY_OF_WEEK.equals((Object)cronField.getField()), "CronField does not belong to day of week");
        this.mondayDoWValue = weekDay;
    }

    @Override
    public int generateNextValue(int n2) {
        On on = (On)this.cronField.getExpression();
        int n3 = this.generateValue(on, this.year, this.month, n2);
        if (n3 <= n2) {
            throw new NoSuchValueException();
        }
        return n3;
    }

    @Override
    public int generatePreviousValue(int n2) {
        On on = (On)this.cronField.getExpression();
        int n3 = this.generateValue(on, this.year, this.month, n2);
        if (n3 >= n2) {
            throw new NoSuchValueException();
        }
        return n3;
    }

    @Override
    public boolean isMatch(int n2) {
        On on = (On)this.cronField.getExpression();
        try {
            return n2 == this.generateValue(on, this.year, this.month, n2 - 1);
        }
        catch (NoSuchValueException noSuchValueException) {
            return false;
        }
    }

    @Override
    protected boolean matchesFieldExpressionClass(FieldExpression fieldExpression) {
        return fieldExpression instanceof On;
    }

    private int generateValue(On on, int n2, int n3, int n4) {
        switch (on.getSpecialChar().getValue()) {
            case HASH: {
                return this.generateHashValues(on, n2, n3);
            }
            case L: {
                return on.getTime().getValue() == -1 ? this.generateNoneValues(ON_SATURDAY, n2, n3, n4) : this.generateLValues(on, n2, n3);
            }
            case NONE: {
                return this.generateNoneValues(on, n2, n3, n4);
            }
        }
        throw new NoSuchValueException();
    }

    private int generateHashValues(On on, int n2, int n3) {
        DayOfWeek dayOfWeek = LocalDate.of(n2, n3, 1).getDayOfWeek();
        int n4 = ConstantsMapper.weekDayMapping(this.mondayDoWValue, ConstantsMapper.JAVA8, on.getTime().getValue());
        int n5 = on.getNth().getValue();
        int n6 = 1;
        int n7 = dayOfWeek.getValue() - n4;
        if (n7 < 0) {
            n6 += Math.abs(n7);
        }
        if (n7 > 0) {
            n6 = n6 + 7 - n7;
        }
        return (n5 - 1) * 7 + n6;
    }

    private int generateLValues(On on, int n2, int n3) {
        int n4;
        int n5 = LocalDate.of(n2, n3, 1).lengthOfMonth();
        LocalDate localDate = LocalDate.of(n2, n3, n5);
        int n6 = localDate.getDayOfWeek().getValue();
        int n7 = n6 - (n4 = ConstantsMapper.weekDayMapping(this.mondayDoWValue, ConstantsMapper.JAVA8, on.getTime().getValue()));
        if (n7 == 0) {
            return localDate.getDayOfMonth();
        }
        if (n7 < 0) {
            return localDate.minusDays((long)n6 + (long)(7 - n4)).getDayOfMonth();
        }
        if (n7 > 0) {
            return localDate.minusDays(n7).getDayOfMonth();
        }
        throw new NoSuchValueException();
    }

    private int generateNoneValues(On on, int n2, int n3, int n4) {
        int n5 = LocalDate.of(n2, n3, 1).getDayOfWeek().getValue();
        int n6 = ConstantsMapper.weekDayMapping(this.mondayDoWValue, ConstantsMapper.JAVA8, on.getTime().getValue());
        int n7 = 1;
        int n8 = n5 - n6;
        if (n8 < 0) {
            n7 += Math.abs(n8);
        }
        if (n8 > 0) {
            n7 = n7 + 7 - n8;
        }
        if (n4 < 1) {
            return n7;
        }
        while (n7 <= n4) {
            n7 += 7;
        }
        return n7;
    }
}

