/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.forseth11.easybackup.dependencies.cronutils.model.CompositeCron;
import me.forseth11.easybackup.dependencies.cronutils.model.Cron;
import me.forseth11.easybackup.dependencies.cronutils.model.SingleCron;
import me.forseth11.easybackup.dependencies.cronutils.model.definition.CronDefinition;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronField;
import me.forseth11.easybackup.dependencies.cronutils.model.field.definition.FieldDefinition;
import me.forseth11.easybackup.dependencies.cronutils.parser.CronParserField;
import me.forseth11.easybackup.dependencies.cronutils.utils.Preconditions;
import me.forseth11.easybackup.dependencies.cronutils.utils.StringUtils;

public class CronParser {
    private final Map<Integer, List<CronParserField>> expressions = new HashMap<Integer, List<CronParserField>>();
    private final CronDefinition cronDefinition;

    public CronParser(CronDefinition cronDefinition) {
        this.cronDefinition = Preconditions.checkNotNull(cronDefinition, "CronDefinition must not be null");
        this.buildPossibleExpressions(cronDefinition);
    }

    private void buildPossibleExpressions(CronDefinition cronDefinition) {
        List<CronParserField> list;
        List<CronParserField> list2 = list = cronDefinition.getFieldDefinitions().stream().map(this::toCronParserField).sorted(CronParserField.createFieldTypeComparator()).collect(Collectors.toList());
        while (this.lastFieldIsOptional(list2)) {
            int n2 = list2.size() - 1;
            ArrayList<CronParserField> arrayList = new ArrayList<CronParserField>(list2.subList(0, n2));
            this.expressions.put(n2, arrayList);
            list2 = arrayList;
        }
        this.expressions.put(list.size(), list);
    }

    private CronParserField toCronParserField(FieldDefinition fieldDefinition) {
        return new CronParserField(fieldDefinition.getFieldName(), fieldDefinition.getConstraints(), fieldDefinition.isOptional());
    }

    private boolean lastFieldIsOptional(List<CronParserField> list) {
        return !list.isEmpty() && list.get(list.size() - 1).isOptional();
    }

    public Cron parse(String string2) {
        Preconditions.checkNotNull(string2, "Expression must not be null");
        String string3 = string2.replaceAll("\\s+", " ").trim();
        if (StringUtils.isEmpty(string3)) {
            throw new IllegalArgumentException("Empty expression!");
        }
        if (string2.contains("|")) {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = Arrays.stream(string2.split("\\s+")).mapToInt(string -> string.split("\\|").length).max().orElse(0);
            for (int i2 = 0; i2 < n2; ++i2) {
                StringBuilder stringBuilder = new StringBuilder();
                for (String string4 : string2.split("\\s+")) {
                    if (string4.contains("|")) {
                        stringBuilder.append(String.format("%s ", string4.split("\\|")[i2]));
                        continue;
                    }
                    stringBuilder.append(String.format("%s ", string4));
                }
                arrayList.add(stringBuilder.toString().trim());
            }
            return new CompositeCron(arrayList.stream().map(string -> this.parse((String)string)).collect(Collectors.toList()));
        }
        String[] stringArray = string3.toUpperCase().split(" ");
        int n3 = stringArray.length;
        String string5 = Arrays.stream(stringArray).filter(string -> string.endsWith(",")).findAny().orElse(null);
        if (string5 != null) {
            throw new IllegalArgumentException(String.format("Invalid field value! Trailing commas not permitted! '%s'", string5));
        }
        List<CronParserField> list = this.expressions.get(n3);
        if (list == null) {
            throw new IllegalArgumentException(String.format("Cron expression contains %s parts but we expect one of %s", n3, this.expressions.keySet()));
        }
        try {
            int n4 = list.size();
            ArrayList<CronField> arrayList = new ArrayList<CronField>(n4 + 1);
            for (int i3 = 0; i3 < n4; ++i3) {
                arrayList.add(list.get(i3).parse(stringArray[i3]));
            }
            return new SingleCron(this.cronDefinition, arrayList).validate();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(String.format("Failed to parse '%s'. %s", string2, illegalArgumentException.getMessage()), illegalArgumentException);
        }
    }
}

