/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.utils;

import java.util.Collection;

public class Preconditions {
    private Preconditions() {
    }

    public static void checkArgument(boolean bl2, Object object) {
        if (!bl2) {
            throw new IllegalArgumentException(String.valueOf(object));
        }
    }

    public static void checkArgument(boolean bl2, String string, Object ... objectArray) {
        if (!bl2) {
            throw new IllegalArgumentException(Preconditions.format(string, objectArray));
        }
    }

    public static void checkState(boolean bl2, String string, Object ... objectArray) {
        if (!bl2) {
            throw new IllegalStateException(Preconditions.format(string, objectArray));
        }
    }

    public static <T> T checkNotNull(T t2) {
        if (t2 == null) {
            throw new NullPointerException();
        }
        return t2;
    }

    public static <T> T checkNotNull(T t2, Object object) {
        if (t2 == null) {
            throw new NullPointerException(String.valueOf(object));
        }
        return t2;
    }

    public static String checkNotNullNorEmpty(String string, Object object) {
        if (string == null) {
            throw new NullPointerException(String.valueOf(object));
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException(String.valueOf(object));
        }
        return string;
    }

    public static <T extends Collection<?>> T checkNotNullNorEmpty(T t2, Object object) {
        if (t2 == null) {
            throw new NullPointerException(String.valueOf(object));
        }
        if (t2.isEmpty()) {
            throw new IllegalArgumentException(String.valueOf(object));
        }
        return t2;
    }

    private static String format(String string, Object ... objectArray) {
        int n2;
        String string2 = String.valueOf(string);
        StringBuilder stringBuilder = new StringBuilder(string2.length() + 16 * objectArray.length);
        int n3 = 0;
        int n4 = 0;
        while (n4 < objectArray.length && (n2 = string2.indexOf("%s", n3)) != -1) {
            stringBuilder.append(string2, n3, n2);
            stringBuilder.append(objectArray[n4++]);
            n3 = n2 + 2;
        }
        stringBuilder.append(string2.substring(n3));
        if (n4 < objectArray.length) {
            stringBuilder.append(" [");
            stringBuilder.append(objectArray[n4++]);
            while (n4 < objectArray.length) {
                stringBuilder.append(", ");
                stringBuilder.append(objectArray[n4++]);
            }
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }
}

