/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.gson.internal.bind;

import java.lang.reflect.Type;
import java.util.Collection;
import me.forseth11.easybackup.dependencies.gson.Gson;
import me.forseth11.easybackup.dependencies.gson.TypeAdapter;
import me.forseth11.easybackup.dependencies.gson.TypeAdapterFactory;
import me.forseth11.easybackup.dependencies.gson.internal.$Gson$Types;
import me.forseth11.easybackup.dependencies.gson.internal.ConstructorConstructor;
import me.forseth11.easybackup.dependencies.gson.internal.ObjectConstructor;
import me.forseth11.easybackup.dependencies.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import me.forseth11.easybackup.dependencies.gson.reflect.TypeToken;
import me.forseth11.easybackup.dependencies.gson.stream.JsonReader;
import me.forseth11.easybackup.dependencies.gson.stream.JsonToken;
import me.forseth11.easybackup.dependencies.gson.stream.JsonWriter;

public final class CollectionTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;

    public CollectionTypeAdapterFactory(ConstructorConstructor constructorConstructor) {
        this.constructorConstructor = constructorConstructor;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Type type = typeToken.getType();
        Class<T> clazz = typeToken.getRawType();
        if (!Collection.class.isAssignableFrom(clazz)) {
            return null;
        }
        Type type2 = $Gson$Types.getCollectionElementType(type, clazz);
        TypeAdapter<?> typeAdapter = gson.getAdapter(TypeToken.get(type2));
        ObjectConstructor<T> objectConstructor = this.constructorConstructor.get(typeToken);
        Adapter adapter = new Adapter(gson, type2, typeAdapter, objectConstructor);
        return adapter;
    }

    private static final class Adapter<E>
    extends TypeAdapter<Collection<E>> {
        private final TypeAdapter<E> elementTypeAdapter;
        private final ObjectConstructor<? extends Collection<E>> constructor;

        public Adapter(Gson gson, Type type, TypeAdapter<E> typeAdapter, ObjectConstructor<? extends Collection<E>> objectConstructor) {
            this.elementTypeAdapter = new TypeAdapterRuntimeTypeWrapper<E>(gson, typeAdapter, type);
            this.constructor = objectConstructor;
        }

        @Override
        public Collection<E> read(JsonReader jsonReader) {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            Collection<E> collection = this.constructor.construct();
            jsonReader.beginArray();
            while (jsonReader.hasNext()) {
                E e2 = this.elementTypeAdapter.read(jsonReader);
                collection.add(e2);
            }
            jsonReader.endArray();
            return collection;
        }

        @Override
        public void write(JsonWriter jsonWriter, Collection<E> collection) {
            if (collection == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.beginArray();
            for (E e2 : collection) {
                this.elementTypeAdapter.write(jsonWriter, e2);
            }
            jsonWriter.endArray();
        }
    }
}

