/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.prettytime;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import me.forseth11.easybackup.dependencies.prettytime.Duration;
import me.forseth11.easybackup.dependencies.prettytime.LocaleAware;
import me.forseth11.easybackup.dependencies.prettytime.TimeFormat;
import me.forseth11.easybackup.dependencies.prettytime.TimeUnit;
import me.forseth11.easybackup.dependencies.prettytime.impl.DurationImpl;
import me.forseth11.easybackup.dependencies.prettytime.impl.ResourcesTimeFormat;
import me.forseth11.easybackup.dependencies.prettytime.impl.ResourcesTimeUnit;
import me.forseth11.easybackup.dependencies.prettytime.units.Century;
import me.forseth11.easybackup.dependencies.prettytime.units.Day;
import me.forseth11.easybackup.dependencies.prettytime.units.Decade;
import me.forseth11.easybackup.dependencies.prettytime.units.Hour;
import me.forseth11.easybackup.dependencies.prettytime.units.JustNow;
import me.forseth11.easybackup.dependencies.prettytime.units.Millennium;
import me.forseth11.easybackup.dependencies.prettytime.units.Millisecond;
import me.forseth11.easybackup.dependencies.prettytime.units.Minute;
import me.forseth11.easybackup.dependencies.prettytime.units.Month;
import me.forseth11.easybackup.dependencies.prettytime.units.Second;
import me.forseth11.easybackup.dependencies.prettytime.units.TimeUnitComparator;
import me.forseth11.easybackup.dependencies.prettytime.units.Week;
import me.forseth11.easybackup.dependencies.prettytime.units.Year;

public class PrettyTime {
    private volatile Date reference;
    private volatile Locale locale = Locale.getDefault();
    private volatile Map<TimeUnit, TimeFormat> units = new LinkedHashMap<TimeUnit, TimeFormat>();
    private volatile List<TimeUnit> cachedUnits;

    public PrettyTime() {
        this.initTimeUnits();
    }

    public PrettyTime(Date date) {
        this();
        this.setReference(date);
    }

    public PrettyTime(Locale locale) {
        this.setLocale(locale);
        this.initTimeUnits();
    }

    public PrettyTime(Date date, Locale locale) {
        this(locale);
        this.setReference(date);
    }

    public Duration approximateDuration(Date date) {
        Date date2;
        if (date == null) {
            date = this.now();
        }
        if (null == (date2 = this.reference)) {
            date2 = this.now();
        }
        long l2 = date.getTime() - date2.getTime();
        return this.calculateDuration(l2);
    }

    public List<Duration> calculatePreciseDuration(Date date) {
        if (date == null) {
            date = this.now();
        }
        if (null == this.reference) {
            this.reference = this.now();
        }
        ArrayList<Duration> arrayList = new ArrayList<Duration>();
        long l2 = date.getTime() - this.reference.getTime();
        Duration duration = this.calculateDuration(l2);
        arrayList.add(duration);
        while (0L != duration.getDelta()) {
            Duration duration2;
            duration = this.calculateDuration(duration.getDelta());
            if (arrayList.size() > 0 && (duration2 = (Duration)arrayList.get(arrayList.size() - 1)).getUnit().equals(duration.getUnit())) break;
            if (!duration.getUnit().isPrecise()) continue;
            arrayList.add(duration);
        }
        return arrayList;
    }

    public String format(Date date) {
        if (date == null) {
            date = this.now();
        }
        Duration duration = this.approximateDuration(date);
        return this.format(duration);
    }

    public String format(Calendar calendar) {
        if (calendar == null) {
            return this.format(this.now());
        }
        return this.format(calendar.getTime());
    }

    public String format(Duration duration) {
        if (duration == null) {
            return this.format(this.now());
        }
        TimeFormat timeFormat = this.getFormat(duration.getUnit());
        String string = timeFormat.format(duration);
        return timeFormat.decorate(duration, string);
    }

    public String format(List<Duration> list) {
        if (list == null || list.isEmpty()) {
            return this.format(this.now());
        }
        StringBuilder stringBuilder = new StringBuilder();
        Duration duration = null;
        TimeFormat timeFormat = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            duration = list.get(i2);
            timeFormat = this.getFormat(duration.getUnit());
            if (i2 < list.size() - 1) {
                stringBuilder.append(timeFormat.formatUnrounded(duration)).append(" ");
                continue;
            }
            stringBuilder.append(timeFormat.format(duration));
        }
        return timeFormat.decorateUnrounded(duration, stringBuilder.toString());
    }

    public String formatUnrounded(Date date) {
        if (date == null) {
            date = this.now();
        }
        Duration duration = this.approximateDuration(date);
        return this.formatUnrounded(duration);
    }

    public String formatUnrounded(Calendar calendar) {
        if (calendar == null) {
            return this.formatUnrounded(this.now());
        }
        return this.formatUnrounded(calendar.getTime());
    }

    public String formatUnrounded(Duration duration) {
        if (duration == null) {
            return this.formatUnrounded(this.now());
        }
        TimeFormat timeFormat = this.getFormat(duration.getUnit());
        String string = timeFormat.formatUnrounded(duration);
        return timeFormat.decorateUnrounded(duration, string);
    }

    public String formatUnrounded(List<Duration> list) {
        if (list == null || list.isEmpty()) {
            return this.format(this.now());
        }
        StringBuilder stringBuilder = new StringBuilder();
        Duration duration = null;
        TimeFormat timeFormat = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            duration = list.get(i2);
            timeFormat = this.getFormat(duration.getUnit());
            stringBuilder.append(timeFormat.formatUnrounded(duration));
            if (i2 >= list.size() - 1) continue;
            stringBuilder.append(" ");
        }
        return timeFormat.decorateUnrounded(duration, stringBuilder.toString());
    }

    public String formatDuration(Date date) {
        Duration duration = this.approximateDuration(date);
        return this.formatDuration(duration);
    }

    public String formatDuration(Calendar calendar) {
        if (calendar == null) {
            return this.formatDuration(this.now());
        }
        Duration duration = this.approximateDuration(calendar.getTime());
        return this.formatDuration(duration);
    }

    public String formatDuration(Duration duration) {
        if (duration == null) {
            return this.format(this.now());
        }
        TimeFormat timeFormat = this.getFormat(duration.getUnit());
        return timeFormat.format(duration);
    }

    public String formatDuration(List<Duration> list) {
        if (list == null || list.isEmpty()) {
            return this.format(this.now());
        }
        StringBuilder stringBuilder = new StringBuilder();
        Duration duration = null;
        TimeFormat timeFormat = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            duration = list.get(i2);
            timeFormat = this.getFormat(duration.getUnit());
            if (i2 < list.size() - 1) {
                stringBuilder.append(timeFormat.formatUnrounded(duration)).append(" ");
                continue;
            }
            stringBuilder.append(timeFormat.format(duration));
        }
        return stringBuilder.toString();
    }

    public String formatDurationUnrounded(Date date) {
        Duration duration = this.approximateDuration(date);
        return this.formatDurationUnrounded(duration);
    }

    public String formatDurationUnrounded(Calendar calendar) {
        if (calendar == null) {
            return this.formatDuration(this.now());
        }
        Duration duration = this.approximateDuration(calendar.getTime());
        return this.formatDurationUnrounded(duration);
    }

    public String formatDurationUnrounded(Duration duration) {
        if (duration == null) {
            return this.format(this.now());
        }
        TimeFormat timeFormat = this.getFormat(duration.getUnit());
        return timeFormat.formatUnrounded(duration);
    }

    public String formatDurationUnrounded(List<Duration> list) {
        if (list == null || list.isEmpty()) {
            return this.format(this.now());
        }
        StringBuilder stringBuilder = new StringBuilder();
        Duration duration = null;
        TimeFormat timeFormat = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            duration = list.get(i2);
            timeFormat = this.getFormat(duration.getUnit());
            stringBuilder.append(timeFormat.formatUnrounded(duration));
            if (i2 >= list.size() - 1) continue;
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public TimeFormat getFormat(TimeUnit timeUnit) {
        if (timeUnit != null && this.units.get(timeUnit) != null) {
            return this.units.get(timeUnit);
        }
        return null;
    }

    public Date getReference() {
        return this.reference;
    }

    public PrettyTime setReference(Date date) {
        this.reference = date;
        return this;
    }

    public List<TimeUnit> getUnits() {
        if (this.cachedUnits == null) {
            ArrayList<TimeUnit> arrayList = new ArrayList<TimeUnit>(this.units.keySet());
            Collections.sort(arrayList, new TimeUnitComparator());
            this.cachedUnits = Collections.unmodifiableList(arrayList);
        }
        return this.cachedUnits;
    }

    public <UNIT extends TimeUnit> UNIT getUnit(Class<UNIT> clazz) {
        if (clazz == null) {
            return null;
        }
        for (TimeUnit timeUnit : this.units.keySet()) {
            if (!clazz.isAssignableFrom(timeUnit.getClass())) continue;
            return (UNIT)timeUnit;
        }
        return null;
    }

    public PrettyTime registerUnit(TimeUnit timeUnit, TimeFormat timeFormat) {
        if (timeUnit == null) {
            throw new IllegalArgumentException("Unit to register must not be null.");
        }
        if (timeFormat == null) {
            throw new IllegalArgumentException("Format to register must not be null.");
        }
        this.cachedUnits = null;
        this.units.put(timeUnit, timeFormat);
        if (timeUnit instanceof LocaleAware) {
            ((LocaleAware)((Object)timeUnit)).setLocale(this.locale);
        }
        if (timeFormat instanceof LocaleAware) {
            ((LocaleAware)((Object)timeFormat)).setLocale(this.locale);
        }
        return this;
    }

    public <UNIT extends TimeUnit> TimeFormat removeUnit(Class<UNIT> clazz) {
        if (clazz == null) {
            return null;
        }
        for (TimeUnit timeUnit : this.units.keySet()) {
            if (!clazz.isAssignableFrom(timeUnit.getClass())) continue;
            this.cachedUnits = null;
            return this.units.remove(timeUnit);
        }
        return null;
    }

    public TimeFormat removeUnit(TimeUnit timeUnit) {
        if (timeUnit == null) {
            return null;
        }
        this.cachedUnits = null;
        return this.units.remove(timeUnit);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public PrettyTime setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.locale = locale;
        for (TimeUnit object : this.units.keySet()) {
            if (!(object instanceof LocaleAware)) continue;
            ((LocaleAware)((Object)object)).setLocale(locale);
        }
        for (TimeFormat timeFormat : this.units.values()) {
            if (!(timeFormat instanceof LocaleAware)) continue;
            ((LocaleAware)((Object)timeFormat)).setLocale(locale);
        }
        return this;
    }

    public String toString() {
        return "PrettyTime [reference=" + this.reference + ", locale=" + this.locale + "]";
    }

    public List<TimeUnit> clearUnits() {
        List<TimeUnit> list = this.getUnits();
        this.cachedUnits = null;
        this.units.clear();
        return list;
    }

    private Date now() {
        return new Date();
    }

    private void initTimeUnits() {
        this.addUnit(new JustNow());
        this.addUnit(new Millisecond());
        this.addUnit(new Second());
        this.addUnit(new Minute());
        this.addUnit(new Hour());
        this.addUnit(new Day());
        this.addUnit(new Week());
        this.addUnit(new Month());
        this.addUnit(new Year());
        this.addUnit(new Decade());
        this.addUnit(new Century());
        this.addUnit(new Millennium());
    }

    private void addUnit(ResourcesTimeUnit resourcesTimeUnit) {
        this.registerUnit(resourcesTimeUnit, new ResourcesTimeFormat(resourcesTimeUnit));
    }

    private Duration calculateDuration(long l2) {
        long l3 = Math.abs(l2);
        List<TimeUnit> list = this.getUnits();
        DurationImpl durationImpl = new DurationImpl();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            boolean bl2;
            TimeUnit timeUnit = list.get(i2);
            long l4 = Math.abs(timeUnit.getMillisPerUnit());
            long l5 = Math.abs(timeUnit.getMaxQuantity());
            boolean bl3 = bl2 = i2 == list.size() - 1;
            if (0L == l5 && !bl2) {
                l5 = list.get(i2 + 1).getMillisPerUnit() / timeUnit.getMillisPerUnit();
            }
            if (l4 * l5 <= l3 && !bl2) continue;
            durationImpl.setUnit(timeUnit);
            if (l4 > l3) {
                durationImpl.setQuantity(this.getSign(l2));
                durationImpl.setDelta(0L);
                break;
            }
            durationImpl.setQuantity(l2 / l4);
            durationImpl.setDelta(l2 - durationImpl.getQuantity() * l4);
            break;
        }
        return durationImpl;
    }

    private long getSign(long l2) {
        if (0L > l2) {
            return -1L;
        }
        return 1L;
    }
}

