/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.prettytime.format;

import me.forseth11.easybackup.dependencies.prettytime.Duration;
import me.forseth11.easybackup.dependencies.prettytime.TimeFormat;

public class SimpleTimeFormat
implements TimeFormat {
    private static final String NEGATIVE = "-";
    public static final String SIGN = "%s";
    public static final String QUANTITY = "%n";
    public static final String UNIT = "%u";
    private String singularName = "";
    private String pluralName = "";
    private String futureSingularName = "";
    private String futurePluralName = "";
    private String pastSingularName = "";
    private String pastPluralName = "";
    private String pattern = "";
    private String futurePrefix = "";
    private String futureSuffix = "";
    private String pastPrefix = "";
    private String pastSuffix = "";
    private int roundingTolerance = 50;

    @Override
    public String format(Duration duration) {
        return this.format(duration, true);
    }

    @Override
    public String formatUnrounded(Duration duration) {
        return this.format(duration, false);
    }

    @Override
    public String decorate(Duration duration, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (duration.isInPast()) {
            stringBuilder.append(this.pastPrefix).append(" ").append(string).append(" ").append(this.pastSuffix);
        } else {
            stringBuilder.append(this.futurePrefix).append(" ").append(string).append(" ").append(this.futureSuffix);
        }
        return stringBuilder.toString().replaceAll("\\s+", " ").trim();
    }

    @Override
    public String decorateUnrounded(Duration duration, String string) {
        return this.decorate(duration, string);
    }

    private String format(Duration duration, boolean bl2) {
        String string = this.getSign(duration);
        String string2 = this.getGramaticallyCorrectName(duration, bl2);
        long l2 = this.getQuantity(duration, bl2);
        return this.applyPattern(string, string2, l2);
    }

    private String applyPattern(String string, String string2, long l2) {
        String string3 = this.getPattern(l2).replaceAll(SIGN, string);
        string3 = string3.replaceAll(QUANTITY, String.valueOf(l2));
        string3 = string3.replaceAll(UNIT, string2);
        return string3;
    }

    protected String getPattern(long l2) {
        return this.pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    protected long getQuantity(Duration duration, boolean bl2) {
        return Math.abs(bl2 ? duration.getQuantityRounded(this.roundingTolerance) : duration.getQuantity());
    }

    protected String getGramaticallyCorrectName(Duration duration, boolean bl2) {
        String string = this.getSingularName(duration);
        if (Math.abs(this.getQuantity(duration, bl2)) == 0L || Math.abs(this.getQuantity(duration, bl2)) > 1L) {
            string = this.getPluralName(duration);
        }
        return string;
    }

    private String getSign(Duration duration) {
        if (duration.getQuantity() < 0L) {
            return NEGATIVE;
        }
        return "";
    }

    private String getSingularName(Duration duration) {
        if (duration.isInFuture() && this.futureSingularName != null && this.futureSingularName.length() > 0) {
            return this.futureSingularName;
        }
        if (duration.isInPast() && this.pastSingularName != null && this.pastSingularName.length() > 0) {
            return this.pastSingularName;
        }
        return this.singularName;
    }

    private String getPluralName(Duration duration) {
        if (duration.isInFuture() && this.futurePluralName != null && this.futureSingularName.length() > 0) {
            return this.futurePluralName;
        }
        if (duration.isInPast() && this.pastPluralName != null && this.pastSingularName.length() > 0) {
            return this.pastPluralName;
        }
        return this.pluralName;
    }

    public SimpleTimeFormat setPattern(String string) {
        this.pattern = string;
        return this;
    }

    public SimpleTimeFormat setFuturePrefix(String string) {
        this.futurePrefix = string.trim();
        return this;
    }

    public SimpleTimeFormat setFutureSuffix(String string) {
        this.futureSuffix = string.trim();
        return this;
    }

    public SimpleTimeFormat setPastPrefix(String string) {
        this.pastPrefix = string.trim();
        return this;
    }

    public SimpleTimeFormat setPastSuffix(String string) {
        this.pastSuffix = string.trim();
        return this;
    }

    public SimpleTimeFormat setRoundingTolerance(int n2) {
        this.roundingTolerance = n2;
        return this;
    }

    public SimpleTimeFormat setSingularName(String string) {
        this.singularName = string;
        return this;
    }

    public SimpleTimeFormat setPluralName(String string) {
        this.pluralName = string;
        return this;
    }

    public SimpleTimeFormat setFutureSingularName(String string) {
        this.futureSingularName = string;
        return this;
    }

    public SimpleTimeFormat setFuturePluralName(String string) {
        this.futurePluralName = string;
        return this;
    }

    public SimpleTimeFormat setPastSingularName(String string) {
        this.pastSingularName = string;
        return this;
    }

    public SimpleTimeFormat setPastPluralName(String string) {
        this.pastPluralName = string;
        return this;
    }

    public String toString() {
        return "SimpleTimeFormat [pattern=" + this.pattern + ", futurePrefix=" + this.futurePrefix + ", futureSuffix=" + this.futureSuffix + ", pastPrefix=" + this.pastPrefix + ", pastSuffix=" + this.pastSuffix + ", roundingTolerance=" + this.roundingTolerance + "]";
    }
}

