/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.prettytime.i18n;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.ResourceBundle;
import me.forseth11.easybackup.dependencies.prettytime.Duration;
import me.forseth11.easybackup.dependencies.prettytime.TimeFormat;
import me.forseth11.easybackup.dependencies.prettytime.TimeUnit;
import me.forseth11.easybackup.dependencies.prettytime.format.SimpleTimeFormat;
import me.forseth11.easybackup.dependencies.prettytime.impl.TimeFormatProvider;
import me.forseth11.easybackup.dependencies.prettytime.units.Day;
import me.forseth11.easybackup.dependencies.prettytime.units.Hour;
import me.forseth11.easybackup.dependencies.prettytime.units.Minute;
import me.forseth11.easybackup.dependencies.prettytime.units.Month;
import me.forseth11.easybackup.dependencies.prettytime.units.Week;
import me.forseth11.easybackup.dependencies.prettytime.units.Year;

public class Resources_cs
extends ListResourceBundle
implements TimeFormatProvider {
    private static final Object[][] OBJECTS = new Object[][]{{"CenturyPattern", "%n %u"}, {"CenturyFuturePrefix", "za "}, {"CenturyFutureSuffix", ""}, {"CenturyPastPrefix", "p\u0159ed "}, {"CenturyPastSuffix", ""}, {"CenturySingularName", "stolet\u00ed"}, {"CenturyPluralName", "stolet\u00ed"}, {"CenturyPastSingularName", "stolet\u00edm"}, {"CenturyPastPluralName", "stolet\u00edmi"}, {"CenturyFutureSingularName", "stolet\u00ed"}, {"CenturyFuturePluralName", "stolet\u00ed"}, {"DayPattern", "%n %u"}, {"DayFuturePrefix", "za "}, {"DayFutureSuffix", ""}, {"DayPastPrefix", "p\u0159ed "}, {"DayPastSuffix", ""}, {"DaySingularName", "den"}, {"DayPluralName", "dny"}, {"DecadePattern", "%n %u"}, {"DecadeFuturePrefix", "za "}, {"DecadeFutureSuffix", ""}, {"DecadePastPrefix", "p\u0159ed "}, {"DecadePastSuffix", ""}, {"DecadeSingularName", "desetilet\u00ed"}, {"DecadePluralName", "desetilet\u00ed"}, {"DecadePastSingularName", "desetilet\u00edm"}, {"DecadePastPluralName", "desetilet\u00edmi"}, {"DecadeFutureSingularName", "desetilet\u00ed"}, {"DecadeFuturePluralName", "desetilet\u00ed"}, {"HourPattern", "%n %u"}, {"HourFuturePrefix", "za "}, {"HourFutureSuffix", ""}, {"HourPastPrefix", "p\u0159ed"}, {"HourPastSuffix", ""}, {"HourSingularName", "hodina"}, {"HourPluralName", "hodiny"}, {"JustNowPattern", "%u"}, {"JustNowFuturePrefix", ""}, {"JustNowFutureSuffix", "za chv\u00edli"}, {"JustNowPastPrefix", "p\u0159ed chv\u00edl\u00ed"}, {"JustNowPastSuffix", ""}, {"JustNowSingularName", ""}, {"JustNowPluralName", ""}, {"MillenniumPattern", "%n %u"}, {"MillenniumFuturePrefix", "za "}, {"MillenniumFutureSuffix", ""}, {"MillenniumPastPrefix", "p\u0159ed "}, {"MillenniumPastSuffix", ""}, {"MillenniumSingularName", "tis\u00edcilet\u00ed"}, {"MillenniumPluralName", "tis\u00edcilet\u00ed"}, {"MillisecondPattern", "%n %u"}, {"MillisecondFuturePrefix", "za "}, {"MillisecondFutureSuffix", ""}, {"MillisecondPastPrefix", "p\u0159ed "}, {"MillisecondPastSuffix", ""}, {"MillisecondSingularName", "milisekunda"}, {"MillisecondPluralName", "milisekundy"}, {"MillisecondPastSingularName", "milisekundou"}, {"MillisecondPastPluralName", "milisekundami"}, {"MillisecondFutureSingularName", "milisekundu"}, {"MillisecondFuturePluralName", "milisekund"}, {"MinutePattern", "%n %u"}, {"MinuteFuturePrefix", "za "}, {"MinuteFutureSuffix", ""}, {"MinutePastPrefix", "p\u0159ed "}, {"MinutePastSuffix", ""}, {"MinuteSingularName", "minuta"}, {"MinutePluralName", "minuty"}, {"MonthPattern", "%n %u"}, {"MonthFuturePrefix", "za "}, {"MonthFutureSuffix", ""}, {"MonthPastPrefix", "p\u0159ed "}, {"MonthPastSuffix", ""}, {"MonthSingularName", "m\u011bs\u00edc"}, {"MonthPluralName", "m\u011bs\u00edce"}, {"SecondPattern", "%n %u"}, {"SecondFuturePrefix", "za "}, {"SecondFutureSuffix", ""}, {"SecondPastPrefix", "p\u0159ed "}, {"SecondPastSuffix", ""}, {"SecondSingularName", "sekunda"}, {"SecondPluralName", "sekundy"}, {"WeekPattern", "%n %u"}, {"WeekFuturePrefix", "za "}, {"WeekFutureSuffix", ""}, {"WeekPastPrefix", "p\u0159ed "}, {"WeekPastSuffix", ""}, {"WeekSingularName", "t\u00fdden"}, {"WeekPluralName", "t\u00fddny"}, {"YearPattern", "%n %u"}, {"YearFuturePrefix", "za "}, {"YearFutureSuffix", ""}, {"YearPastPrefix", "p\u0159ed "}, {"YearPastSuffix", ""}, {"YearSingularName", "rok"}, {"YearPluralName", "roky"}, {"AbstractTimeUnitPattern", ""}, {"AbstractTimeUnitFuturePrefix", ""}, {"AbstractTimeUnitFutureSuffix", ""}, {"AbstractTimeUnitPastPrefix", ""}, {"AbstractTimeUnitPastSuffix", ""}, {"AbstractTimeUnitSingularName", ""}, {"AbstractTimeUnitPluralName", ""}};

    @Override
    public Object[][] getContents() {
        return OBJECTS;
    }

    @Override
    public TimeFormat getFormatFor(TimeUnit timeUnit) {
        if (timeUnit instanceof Minute) {
            return new CsTimeFormatBuilder("Minute").addFutureName("minutu", 1L).addFutureName("minuty", 4L).addFutureName("minut", Long.MAX_VALUE).addPastName("minutou", 1L).addPastName("minutami", Long.MAX_VALUE).build(this);
        }
        if (timeUnit instanceof Hour) {
            return new CsTimeFormatBuilder("Hour").addFutureName("hodinu", 1L).addFutureName("hodiny", 4L).addFutureName("hodin", Long.MAX_VALUE).addPastName("hodinou", 1L).addPastName("hodinami", Long.MAX_VALUE).build(this);
        }
        if (timeUnit instanceof Day) {
            return new CsTimeFormatBuilder("Day").addFutureName("den", 1L).addFutureName("dny", 4L).addFutureName("dn\u00ed", Long.MAX_VALUE).addPastName("dnem", 1L).addPastName("dny", Long.MAX_VALUE).build(this);
        }
        if (timeUnit instanceof Week) {
            return new CsTimeFormatBuilder("Week").addFutureName("t\u00fdden", 1L).addFutureName("t\u00fddny", 4L).addFutureName("t\u00fddn\u016f", Long.MAX_VALUE).addPastName("t\u00fddnem", 1L).addPastName("t\u00fddny", Long.MAX_VALUE).build(this);
        }
        if (timeUnit instanceof Month) {
            return new CsTimeFormatBuilder("Month").addFutureName("m\u011bs\u00edc", 1L).addFutureName("m\u011bs\u00edce", 4L).addFutureName("m\u011bs\u00edc\u016f", Long.MAX_VALUE).addPastName("m\u011bs\u00edcem", 1L).addPastName("m\u011bs\u00edci", Long.MAX_VALUE).build(this);
        }
        if (timeUnit instanceof Year) {
            return new CsTimeFormatBuilder("Year").addFutureName("rok", 1L).addFutureName("roky", 4L).addFutureName("let", Long.MAX_VALUE).addPastName("rokem", 1L).addPastName("roky", Long.MAX_VALUE).build(this);
        }
        return null;
    }

    private static class CsName
    implements Comparable<CsName> {
        private final boolean isFuture;
        private final String value;
        private final Long threshold;

        public CsName(boolean bl2, String string, Long l2) {
            this.isFuture = bl2;
            this.value = string;
            this.threshold = l2;
        }

        public boolean isFuture() {
            return this.isFuture;
        }

        public String get() {
            return this.value;
        }

        public long getThreshold() {
            return this.threshold;
        }

        @Override
        public int compareTo(CsName csName) {
            return this.threshold.compareTo(csName.getThreshold());
        }
    }

    private static class CsTimeFormat
    extends SimpleTimeFormat
    implements TimeFormat {
        private final List<CsName> futureNames = new ArrayList<CsName>();
        private final List<CsName> pastNames = new ArrayList<CsName>();

        public CsTimeFormat(String string, ResourceBundle resourceBundle, Collection<CsName> collection) {
            this.setPattern(resourceBundle.getString(string + "Pattern"));
            this.setFuturePrefix(resourceBundle.getString(string + "FuturePrefix"));
            this.setFutureSuffix(resourceBundle.getString(string + "FutureSuffix"));
            this.setPastPrefix(resourceBundle.getString(string + "PastPrefix"));
            this.setPastSuffix(resourceBundle.getString(string + "PastSuffix"));
            this.setSingularName(resourceBundle.getString(string + "SingularName"));
            this.setPluralName(resourceBundle.getString(string + "PluralName"));
            try {
                this.setFuturePluralName(resourceBundle.getString(string + "FuturePluralName"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.setFutureSingularName(resourceBundle.getString(string + "FutureSingularName"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.setPastPluralName(resourceBundle.getString(string + "PastPluralName"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.setPastSingularName(resourceBundle.getString(string + "PastSingularName"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (CsName csName : collection) {
                if (csName.isFuture()) {
                    this.futureNames.add(csName);
                    continue;
                }
                this.pastNames.add(csName);
            }
            Collections.sort(this.futureNames);
            Collections.sort(this.pastNames);
        }

        @Override
        protected String getGramaticallyCorrectName(Duration duration, boolean bl2) {
            long l2 = Math.abs(this.getQuantity(duration, bl2));
            if (duration.isInFuture()) {
                return this.getGramaticallyCorrectName(l2, this.futureNames);
            }
            return this.getGramaticallyCorrectName(l2, this.pastNames);
        }

        private String getGramaticallyCorrectName(long l2, List<CsName> list) {
            for (CsName csName : list) {
                if (csName.getThreshold() < l2) continue;
                return csName.get();
            }
            throw new IllegalStateException("Invalid resource bundle configuration");
        }
    }

    private static class CsTimeFormatBuilder {
        private List<CsName> names = new ArrayList<CsName>();
        private String resourceKeyPrefix;

        CsTimeFormatBuilder(String string) {
            this.resourceKeyPrefix = string;
        }

        CsTimeFormatBuilder addFutureName(String string, long l2) {
            return this.addName(true, string, l2);
        }

        CsTimeFormatBuilder addPastName(String string, long l2) {
            return this.addName(false, string, l2);
        }

        private CsTimeFormatBuilder addName(boolean bl2, String string, long l2) {
            if (string == null) {
                throw new IllegalArgumentException();
            }
            this.names.add(new CsName(bl2, string, l2));
            return this;
        }

        CsTimeFormat build(ResourceBundle resourceBundle) {
            return new CsTimeFormat(this.resourceKeyPrefix, resourceBundle, this.names);
        }
    }
}

