/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.prettytime.i18n;

import java.util.ListResourceBundle;
import me.forseth11.easybackup.dependencies.prettytime.Duration;
import me.forseth11.easybackup.dependencies.prettytime.TimeFormat;
import me.forseth11.easybackup.dependencies.prettytime.TimeUnit;
import me.forseth11.easybackup.dependencies.prettytime.impl.TimeFormatProvider;
import me.forseth11.easybackup.dependencies.prettytime.units.Century;
import me.forseth11.easybackup.dependencies.prettytime.units.Day;
import me.forseth11.easybackup.dependencies.prettytime.units.Decade;
import me.forseth11.easybackup.dependencies.prettytime.units.Hour;
import me.forseth11.easybackup.dependencies.prettytime.units.JustNow;
import me.forseth11.easybackup.dependencies.prettytime.units.Millennium;
import me.forseth11.easybackup.dependencies.prettytime.units.Millisecond;
import me.forseth11.easybackup.dependencies.prettytime.units.Minute;
import me.forseth11.easybackup.dependencies.prettytime.units.Month;
import me.forseth11.easybackup.dependencies.prettytime.units.Second;
import me.forseth11.easybackup.dependencies.prettytime.units.Week;
import me.forseth11.easybackup.dependencies.prettytime.units.Year;

public class Resources_ru
extends ListResourceBundle
implements TimeFormatProvider {
    private static final Object[][] OBJECTS = new Object[0][0];
    private static final int tolerance = 50;
    private static final int russianPluralForms = 3;

    @Override
    public Object[][] getContents() {
        return OBJECTS;
    }

    @Override
    public TimeFormat getFormatFor(TimeUnit timeUnit) {
        if (timeUnit instanceof JustNow) {
            return new TimeFormat(){

                @Override
                public String format(Duration duration) {
                    return this.performFormat(duration);
                }

                @Override
                public String formatUnrounded(Duration duration) {
                    return this.performFormat(duration);
                }

                private String performFormat(Duration duration) {
                    if (duration.isInFuture()) {
                        return "\u0441\u0435\u0439\u0447\u0430\u0441";
                    }
                    if (duration.isInPast()) {
                        return "\u0442\u043e\u043b\u044c\u043a\u043e \u0447\u0442\u043e";
                    }
                    return null;
                }

                @Override
                public String decorate(Duration duration, String string) {
                    return string;
                }

                @Override
                public String decorateUnrounded(Duration duration, String string) {
                    return string;
                }
            };
        }
        if (timeUnit instanceof Century) {
            return new TimeFormatAided("\u0432\u0435\u043a", "\u0432\u0435\u043a\u0430", "\u0432\u0435\u043a\u043e\u0432");
        }
        if (timeUnit instanceof Day) {
            return new TimeFormatAided("\u0434\u0435\u043d\u044c", "\u0434\u043d\u044f", "\u0434\u043d\u0435\u0439");
        }
        if (timeUnit instanceof Decade) {
            return new TimeFormatAided("\u0434\u0435\u0441\u044f\u0442\u0438\u043b\u0435\u0442\u0438\u0435", "\u0434\u0435\u0441\u044f\u0442\u0438\u043b\u0435\u0442\u0438\u044f", "\u0434\u0435\u0441\u044f\u0442\u0438\u043b\u0435\u0442\u0438\u0439");
        }
        if (timeUnit instanceof Hour) {
            return new TimeFormatAided("\u0447\u0430\u0441", "\u0447\u0430\u0441\u0430", "\u0447\u0430\u0441\u043e\u0432");
        }
        if (timeUnit instanceof Millennium) {
            return new TimeFormatAided("\u0442\u044b\u0441\u044f\u0447\u0435\u043b\u0435\u0442\u0438\u0435", "\u0442\u044b\u0441\u044f\u0447\u0435\u043b\u0435\u0442\u0438\u044f", "\u0442\u044b\u0441\u044f\u0447\u0435\u043b\u0435\u0442\u0438\u0439");
        }
        if (timeUnit instanceof Millisecond) {
            return new TimeFormatAided("\u043c\u0438\u043b\u043b\u0438\u0441\u0435\u043a\u0443\u043d\u0434\u0443", "\u043c\u0438\u043b\u043b\u0438\u0441\u0435\u043a\u0443\u043d\u0434\u044b", "\u043c\u0438\u043b\u043b\u0438\u0441\u0435\u043a\u0443\u043d\u0434");
        }
        if (timeUnit instanceof Minute) {
            return new TimeFormatAided("\u043c\u0438\u043d\u0443\u0442\u0443", "\u043c\u0438\u043d\u0443\u0442\u044b", "\u043c\u0438\u043d\u0443\u0442");
        }
        if (timeUnit instanceof Month) {
            return new TimeFormatAided("\u043c\u0435\u0441\u044f\u0446", "\u043c\u0435\u0441\u044f\u0446\u0430", "\u043c\u0435\u0441\u044f\u0446\u0435\u0432");
        }
        if (timeUnit instanceof Second) {
            return new TimeFormatAided("\u0441\u0435\u043a\u0443\u043d\u0434\u0443", "\u0441\u0435\u043a\u0443\u043d\u0434\u044b", "\u0441\u0435\u043a\u0443\u043d\u0434");
        }
        if (timeUnit instanceof Week) {
            return new TimeFormatAided("\u043d\u0435\u0434\u0435\u043b\u044e", "\u043d\u0435\u0434\u0435\u043b\u0438", "\u043d\u0435\u0434\u0435\u043b\u044c");
        }
        if (timeUnit instanceof Year) {
            return new TimeFormatAided("\u0433\u043e\u0434", "\u0433\u043e\u0434\u0430", "\u043b\u0435\u0442");
        }
        return null;
    }

    private static class TimeFormatAided
    implements TimeFormat {
        private final String[] pluarls;

        public TimeFormatAided(String ... stringArray) {
            if (stringArray.length != 3) {
                throw new IllegalArgumentException("Wrong plural forms number for russian language!");
            }
            this.pluarls = stringArray;
        }

        @Override
        public String format(Duration duration) {
            long l2 = duration.getQuantityRounded(50);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(l2);
            return stringBuilder.toString();
        }

        @Override
        public String formatUnrounded(Duration duration) {
            long l2 = duration.getQuantity();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(l2);
            return stringBuilder.toString();
        }

        @Override
        public String decorate(Duration duration, String string) {
            return this.performDecoration(duration.isInPast(), duration.isInFuture(), duration.getQuantityRounded(50), string);
        }

        @Override
        public String decorateUnrounded(Duration duration, String string) {
            return this.performDecoration(duration.isInPast(), duration.isInFuture(), duration.getQuantity(), string);
        }

        private String performDecoration(boolean bl2, boolean bl3, long l2, String string) {
            int n2;
            int n3 = l2 % 10L == 1L && l2 % 100L != 11L ? 0 : (n2 = l2 % 10L >= 2L && l2 % 10L <= 4L && (l2 % 100L < 10L || l2 % 100L >= 20L) ? 1 : 2);
            if (n2 > 3) {
                throw new IllegalStateException("Wrong plural index was calculated somehow for russian language");
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (bl3) {
                stringBuilder.append("\u0447\u0435\u0440\u0435\u0437 ");
            }
            stringBuilder.append(string);
            stringBuilder.append(' ');
            stringBuilder.append(this.pluarls[n2]);
            if (bl2) {
                stringBuilder.append(" \u043d\u0430\u0437\u0430\u0434");
            }
            return stringBuilder.toString();
        }
    }
}

