/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.prettytime.i18n;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.ResourceBundle;
import me.forseth11.easybackup.dependencies.prettytime.Duration;
import me.forseth11.easybackup.dependencies.prettytime.TimeFormat;
import me.forseth11.easybackup.dependencies.prettytime.TimeUnit;
import me.forseth11.easybackup.dependencies.prettytime.format.SimpleTimeFormat;
import me.forseth11.easybackup.dependencies.prettytime.impl.TimeFormatProvider;
import me.forseth11.easybackup.dependencies.prettytime.units.Day;
import me.forseth11.easybackup.dependencies.prettytime.units.Hour;
import me.forseth11.easybackup.dependencies.prettytime.units.Minute;
import me.forseth11.easybackup.dependencies.prettytime.units.Month;
import me.forseth11.easybackup.dependencies.prettytime.units.Week;
import me.forseth11.easybackup.dependencies.prettytime.units.Year;

public class Resources_sk
extends ListResourceBundle
implements TimeFormatProvider {
    private static final Object[][] OBJECTS = new Object[][]{{"CenturyPattern", "%n %u"}, {"CenturyFuturePrefix", "o "}, {"CenturyFutureSuffix", ""}, {"CenturyPastPrefix", "pred "}, {"CenturyPastSuffix", ""}, {"CenturySingularName", "storo\u010die"}, {"CenturyPluralName", "storo\u010dia"}, {"CenturyPastSingularName", "storo\u010d\u00edm"}, {"CenturyPastPluralName", "storo\u010diami"}, {"CenturyFutureSingularName", "storo\u010d\u00ed"}, {"CenturyFuturePluralName", "storo\u010dia"}, {"DayPattern", "%n %u"}, {"DayFuturePrefix", "o "}, {"DayFutureSuffix", ""}, {"DayPastPrefix", "pred "}, {"DayPastSuffix", ""}, {"DaySingularName", "de\u0148"}, {"DayPluralName", "dni"}, {"DecadePattern", "%n %u"}, {"DecadeFuturePrefix", "o "}, {"DecadeFutureSuffix", ""}, {"DecadePastPrefix", "pred "}, {"DecadePastSuffix", ""}, {"DecadeSingularName", "desa\u0165ro\u010die"}, {"DecadePluralName", "desa\u0165ro\u010dia"}, {"DecadePastSingularName", "desa\u0165ro\u010d\u00edm"}, {"DecadePastPluralName", "desa\u0165ro\u010diami"}, {"DecadeFutureSingularName", "desa\u0165ro\u010d\u00ed"}, {"DecadeFuturePluralName", "desa\u0165ro\u010dia"}, {"HourPattern", "%n %u"}, {"HourFuturePrefix", "o "}, {"HourFutureSuffix", ""}, {"HourPastPrefix", "pred"}, {"HourPastSuffix", ""}, {"HourSingularName", "hodina"}, {"HourPluralName", "hodiny"}, {"JustNowPattern", "%u"}, {"JustNowFuturePrefix", ""}, {"JustNowFutureSuffix", "o chv\u00ed\u013eu"}, {"JustNowPastPrefix", "pred chv\u00ed\u013eou"}, {"JustNowPastSuffix", ""}, {"JustNowSingularName", ""}, {"JustNowPluralName", ""}, {"MillenniumPattern", "%n %u"}, {"MillenniumFuturePrefix", "o "}, {"MillenniumFutureSuffix", ""}, {"MillenniumPastPrefix", "pred "}, {"MillenniumPastSuffix", ""}, {"MillenniumSingularName", "t\u00eds\u00edcro\u010die"}, {"MillenniumPluralName", "tis\u00edcro\u010dia"}, {"MillisecondPattern", "%n %u"}, {"MillisecondFuturePrefix", "o "}, {"MillisecondFutureSuffix", ""}, {"MillisecondPastPrefix", "pred "}, {"MillisecondPastSuffix", ""}, {"MillisecondSingularName", "milisekunda"}, {"MillisecondPluralName", "milisekundy"}, {"MillisecondPastSingularName", "milisekundou"}, {"MillisecondPastPluralName", "milisekundami"}, {"MillisecondFutureSingularName", "milisekundu"}, {"MillisecondFuturePluralName", "milisek\u00fand"}, {"MinutePattern", "%n %u"}, {"MinuteFuturePrefix", "o "}, {"MinuteFutureSuffix", ""}, {"MinutePastPrefix", "pred "}, {"MinutePastSuffix", ""}, {"MinuteSingularName", "min\u00fata"}, {"MinutePluralName", "min\u00faty"}, {"MonthPattern", "%n %u"}, {"MonthFuturePrefix", "o "}, {"MonthFutureSuffix", ""}, {"MonthPastPrefix", "pred "}, {"MonthPastSuffix", ""}, {"MonthSingularName", "mesiac"}, {"MonthPluralName", "mesiace"}, {"SecondPattern", "%n %u"}, {"SecondFuturePrefix", "o "}, {"SecondFutureSuffix", ""}, {"SecondPastPrefix", "pred "}, {"SecondPastSuffix", ""}, {"SecondSingularName", "sekunda"}, {"SecondPluralName", "sekundy"}, {"WeekPattern", "%n %u"}, {"WeekFuturePrefix", "o "}, {"WeekFutureSuffix", ""}, {"WeekPastPrefix", "pred "}, {"WeekPastSuffix", ""}, {"WeekSingularName", "t\u00fd\u017ede\u0148"}, {"WeekPluralName", "t\u00fd\u017edne"}, {"YearPattern", "%n %u"}, {"YearFuturePrefix", "o "}, {"YearFutureSuffix", ""}, {"YearPastPrefix", "pred "}, {"YearPastSuffix", ""}, {"YearSingularName", "rok"}, {"YearPluralName", "roky"}, {"AbstractTimeUnitPattern", ""}, {"AbstractTimeUnitFuturePrefix", ""}, {"AbstractTimeUnitFutureSuffix", ""}, {"AbstractTimeUnitPastPrefix", ""}, {"AbstractTimeUnitPastSuffix", ""}, {"AbstractTimeUnitSingularName", ""}, {"AbstractTimeUnitPluralName", ""}};

    @Override
    public Object[][] getContents() {
        return OBJECTS;
    }

    @Override
    public TimeFormat getFormatFor(TimeUnit timeUnit) {
        if (timeUnit instanceof Minute) {
            return new CsTimeFormatBuilder("Minute").addFutureName("min\u00fatu", 1L).addFutureName("min\u00faty", 4L).addFutureName("min\u00fat", Long.MAX_VALUE).addPastName("min\u00fatou", 1L).addPastName("min\u00fatami", Long.MAX_VALUE).build(this);
        }
        if (timeUnit instanceof Hour) {
            return new CsTimeFormatBuilder("Hour").addFutureName("hodinu", 1L).addFutureName("hodiny", 4L).addFutureName("hod\u00edn", Long.MAX_VALUE).addPastName("hodinou", 1L).addPastName("hodinami", Long.MAX_VALUE).build(this);
        }
        if (timeUnit instanceof Day) {
            return new CsTimeFormatBuilder("Day").addFutureName("de\u0148", 1L).addFutureName("dni", 4L).addFutureName("dn\u00ed", Long.MAX_VALUE).addPastName("d\u0148om", 1L).addPastName("d\u0148ami", Long.MAX_VALUE).build(this);
        }
        if (timeUnit instanceof Week) {
            return new CsTimeFormatBuilder("Week").addFutureName("t\u00fd\u017ede\u0148", 1L).addFutureName("t\u00fd\u017edne", 4L).addFutureName("t\u00fd\u017ed\u0148ov", Long.MAX_VALUE).addPastName("t\u00fd\u017ed\u0148om", 1L).addPastName("t\u00fd\u017ed\u0148ami", Long.MAX_VALUE).build(this);
        }
        if (timeUnit instanceof Month) {
            return new CsTimeFormatBuilder("Month").addFutureName("mesiac", 1L).addFutureName("mesiace", 4L).addFutureName("mesiacov", Long.MAX_VALUE).addPastName("mesiacom", 1L).addPastName("mesiacmi", Long.MAX_VALUE).build(this);
        }
        if (timeUnit instanceof Year) {
            return new CsTimeFormatBuilder("Year").addFutureName("rok", 1L).addFutureName("roky", 4L).addFutureName("rokov", Long.MAX_VALUE).addPastName("rokom", 1L).addPastName("rokmi", Long.MAX_VALUE).build(this);
        }
        return null;
    }

    private static class CsName
    implements Comparable<CsName> {
        private final boolean isFuture;
        private final String value;
        private final Long threshold;

        public CsName(boolean bl2, String string, Long l2) {
            this.isFuture = bl2;
            this.value = string;
            this.threshold = l2;
        }

        public boolean isFuture() {
            return this.isFuture;
        }

        public String get() {
            return this.value;
        }

        public long getThreshold() {
            return this.threshold;
        }

        @Override
        public int compareTo(CsName csName) {
            return this.threshold.compareTo(csName.getThreshold());
        }
    }

    private static class CsTimeFormat
    extends SimpleTimeFormat
    implements TimeFormat {
        private final List<CsName> futureNames = new ArrayList<CsName>();
        private final List<CsName> pastNames = new ArrayList<CsName>();

        public CsTimeFormat(String string, ResourceBundle resourceBundle, Collection<CsName> collection) {
            this.setPattern(resourceBundle.getString(string + "Pattern"));
            this.setFuturePrefix(resourceBundle.getString(string + "FuturePrefix"));
            this.setFutureSuffix(resourceBundle.getString(string + "FutureSuffix"));
            this.setPastPrefix(resourceBundle.getString(string + "PastPrefix"));
            this.setPastSuffix(resourceBundle.getString(string + "PastSuffix"));
            this.setSingularName(resourceBundle.getString(string + "SingularName"));
            this.setPluralName(resourceBundle.getString(string + "PluralName"));
            try {
                this.setFuturePluralName(resourceBundle.getString(string + "FuturePluralName"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.setFutureSingularName(resourceBundle.getString(string + "FutureSingularName"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.setPastPluralName(resourceBundle.getString(string + "PastPluralName"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.setPastSingularName(resourceBundle.getString(string + "PastSingularName"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (CsName csName : collection) {
                if (csName.isFuture()) {
                    this.futureNames.add(csName);
                    continue;
                }
                this.pastNames.add(csName);
            }
            Collections.sort(this.futureNames);
            Collections.sort(this.pastNames);
        }

        @Override
        protected String getGramaticallyCorrectName(Duration duration, boolean bl2) {
            long l2 = Math.abs(this.getQuantity(duration, bl2));
            if (duration.isInFuture()) {
                return this.getGramaticallyCorrectName(l2, this.futureNames);
            }
            return this.getGramaticallyCorrectName(l2, this.pastNames);
        }

        private String getGramaticallyCorrectName(long l2, List<CsName> list) {
            for (CsName csName : list) {
                if (csName.getThreshold() < l2) continue;
                return csName.get();
            }
            throw new IllegalStateException("Invalid resource bundle configuration");
        }
    }

    private static class CsTimeFormatBuilder {
        private List<CsName> names = new ArrayList<CsName>();
        private String resourceKeyPrefix;

        CsTimeFormatBuilder(String string) {
            this.resourceKeyPrefix = string;
        }

        CsTimeFormatBuilder addFutureName(String string, long l2) {
            return this.addName(true, string, l2);
        }

        CsTimeFormatBuilder addPastName(String string, long l2) {
            return this.addName(false, string, l2);
        }

        private CsTimeFormatBuilder addName(boolean bl2, String string, long l2) {
            if (string == null) {
                throw new IllegalArgumentException();
            }
            this.names.add(new CsName(bl2, string, l2));
            return this;
        }

        CsTimeFormat build(ResourceBundle resourceBundle) {
            return new CsTimeFormat(this.resourceKeyPrefix, resourceBundle, this.names);
        }
    }
}

