/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.prettytime.impl;

import me.forseth11.easybackup.dependencies.prettytime.Duration;
import me.forseth11.easybackup.dependencies.prettytime.TimeUnit;

public class DurationImpl
implements Duration {
    private long quantity;
    private long delta;
    private TimeUnit unit;

    @Override
    public long getQuantity() {
        return this.quantity;
    }

    public void setQuantity(long l2) {
        this.quantity = l2;
    }

    @Override
    public TimeUnit getUnit() {
        return this.unit;
    }

    public void setUnit(TimeUnit timeUnit) {
        this.unit = timeUnit;
    }

    @Override
    public long getDelta() {
        return this.delta;
    }

    public void setDelta(long l2) {
        this.delta = l2;
    }

    @Override
    public boolean isInPast() {
        return this.getQuantity() < 0L;
    }

    @Override
    public boolean isInFuture() {
        return !this.isInPast();
    }

    @Override
    public long getQuantityRounded(int n2) {
        double d3;
        long l2 = Math.abs(this.getQuantity());
        if (this.getDelta() != 0L && (d3 = Math.abs((double)this.getDelta() / (double)this.getUnit().getMillisPerUnit() * 100.0)) > (double)n2) {
            ++l2;
        }
        return l2;
    }

    public String toString() {
        return "DurationImpl [" + this.quantity + " " + this.unit + ", delta=" + this.delta + "]";
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (int)(this.delta ^ this.delta >>> 32);
        n3 = 31 * n3 + (int)(this.quantity ^ this.quantity >>> 32);
        n3 = 31 * n3 + (this.unit == null ? 0 : this.unit.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DurationImpl durationImpl = (DurationImpl)object;
        if (this.delta != durationImpl.delta) {
            return false;
        }
        if (this.quantity != durationImpl.quantity) {
            return false;
        }
        return !(this.unit == null ? durationImpl.unit != null : !this.unit.equals(durationImpl.unit));
    }
}

