/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.sentry.event;

import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.CRC32;
import me.forseth11.easybackup.dependencies.sentry.event.Breadcrumb;
import me.forseth11.easybackup.dependencies.sentry.event.Event;
import me.forseth11.easybackup.dependencies.sentry.event.Sdk;
import me.forseth11.easybackup.dependencies.sentry.event.interfaces.SentryInterface;
import me.forseth11.easybackup.dependencies.sentry.event.interfaces.SentryStackTraceElement;
import me.forseth11.easybackup.dependencies.sl4j.Logger;
import me.forseth11.easybackup.dependencies.sl4j.LoggerFactory;

public class EventBuilder {
    public static final String DEFAULT_PLATFORM = "java";
    public static final String DEFAULT_HOSTNAME = "unavailable";
    public static final long HOSTNAME_CACHE_DURATION = TimeUnit.HOURS.toMillis(5L);
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final HostnameCache HOSTNAME_CACHE = new HostnameCache(HOSTNAME_CACHE_DURATION);
    private final Event event;
    private boolean alreadyBuilt = false;
    private Set<String> sdkIntegrations = new HashSet<String>();

    public EventBuilder() {
        this(UUID.randomUUID());
    }

    public EventBuilder(UUID uUID) {
        this.event = new Event(uUID);
    }

    private static String calculateChecksum(String string) {
        byte[] byArray = string.getBytes(UTF_8);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, 0, byArray.length);
        return Long.toHexString(cRC32.getValue()).toUpperCase();
    }

    private void autoSetMissingValues() {
        if (this.event.getTimestamp() == null) {
            this.event.setTimestamp(new Date());
        }
        if (this.event.getPlatform() == null) {
            this.event.setPlatform(DEFAULT_PLATFORM);
        }
        if (this.event.getSdk() == null) {
            this.event.setSdk(new Sdk("sentry-java", "1.7.23-1d154", this.sdkIntegrations));
        }
        if (this.event.getServerName() == null) {
            this.event.setServerName(HOSTNAME_CACHE.getHostname());
        }
    }

    private void makeImmutable() {
        this.event.setTags(Collections.unmodifiableMap(this.event.getTags()));
        this.event.setBreadcrumbs(Collections.unmodifiableList(this.event.getBreadcrumbs()));
        HashMap<String, Map<String, Object>> hashMap = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, Map<String, Object>> entry : this.event.getContexts().entrySet()) {
            hashMap.put(entry.getKey(), Collections.unmodifiableMap(entry.getValue()));
        }
        this.event.setContexts(Collections.unmodifiableMap(hashMap));
        this.event.setExtra(Collections.unmodifiableMap(this.event.getExtra()));
        this.event.setSentryInterfaces(Collections.unmodifiableMap(this.event.getSentryInterfaces()));
    }

    public EventBuilder withMessage(String string) {
        this.event.setMessage(string);
        return this;
    }

    public EventBuilder withTimestamp(Date date) {
        this.event.setTimestamp(date);
        return this;
    }

    public EventBuilder withLevel(Event.Level level) {
        this.event.setLevel(level);
        return this;
    }

    public EventBuilder withRelease(String string) {
        this.event.setRelease(string);
        return this;
    }

    public EventBuilder withDist(String string) {
        this.event.setDist(string);
        return this;
    }

    public EventBuilder withEnvironment(String string) {
        this.event.setEnvironment(string);
        return this;
    }

    public EventBuilder withLogger(String string) {
        this.event.setLogger(string);
        return this;
    }

    public EventBuilder withPlatform(String string) {
        this.event.setPlatform(string);
        return this;
    }

    public EventBuilder withSdkIntegration(String string) {
        this.sdkIntegrations.add(string);
        return this;
    }

    @Deprecated
    public EventBuilder withCulprit(SentryStackTraceElement sentryStackTraceElement) {
        return this.withCulprit(this.buildCulpritString(sentryStackTraceElement.getModule(), sentryStackTraceElement.getFunction(), sentryStackTraceElement.getFileName(), sentryStackTraceElement.getLineno()));
    }

    @Deprecated
    public EventBuilder withCulprit(StackTraceElement stackTraceElement) {
        return this.withCulprit(this.buildCulpritString(stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getFileName(), stackTraceElement.getLineNumber()));
    }

    private String buildCulpritString(String string, String string2, String string3, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append(".").append(string2);
        if (string3 != null && !string3.isEmpty()) {
            stringBuilder.append("(").append(string3);
            if (n2 >= 0) {
                stringBuilder.append(":").append(n2);
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public EventBuilder withCulprit(String string) {
        this.event.setCulprit(string);
        return this;
    }

    public EventBuilder withTransaction(String string) {
        this.event.setTransaction(string);
        return this;
    }

    public EventBuilder withTag(String string, String string2) {
        this.event.getTags().put(string, string2);
        return this;
    }

    public EventBuilder withBreadcrumbs(List<Breadcrumb> list) {
        this.event.setBreadcrumbs(list);
        return this;
    }

    public EventBuilder withContexts(Map<String, Map<String, Object>> map) {
        this.event.setContexts(map);
        return this;
    }

    public EventBuilder withServerName(String string) {
        this.event.setServerName(string);
        return this;
    }

    public EventBuilder withExtra(String string, Object object) {
        this.event.getExtra().put(string, object);
        return this;
    }

    public EventBuilder withFingerprint(String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        Collections.addAll(arrayList, stringArray);
        this.event.setFingerprint(arrayList);
        return this;
    }

    public EventBuilder withFingerprint(List<String> list) {
        this.event.setFingerprint(list);
        return this;
    }

    public EventBuilder withChecksumFor(String string) {
        return this.withChecksum(EventBuilder.calculateChecksum(string));
    }

    public EventBuilder withChecksum(String string) {
        this.event.setChecksum(string);
        return this;
    }

    public EventBuilder withSentryInterface(SentryInterface sentryInterface) {
        return this.withSentryInterface(sentryInterface, true);
    }

    public EventBuilder withSentryInterface(SentryInterface sentryInterface, boolean bl2) {
        if (bl2 || !this.event.getSentryInterfaces().containsKey(sentryInterface.getInterfaceName())) {
            this.event.getSentryInterfaces().put(sentryInterface.getInterfaceName(), sentryInterface);
        }
        return this;
    }

    public synchronized Event build() {
        if (this.alreadyBuilt) {
            throw new IllegalStateException("A message can't be built twice");
        }
        this.autoSetMissingValues();
        this.makeImmutable();
        this.alreadyBuilt = true;
        return this.event;
    }

    public Event getEvent() {
        return this.event;
    }

    public String toString() {
        return "EventBuilder{event=" + this.event + ", alreadyBuilt=" + this.alreadyBuilt + '}';
    }

    private static final class HostnameCache {
        public static final long GET_HOSTNAME_TIMEOUT = TimeUnit.SECONDS.toMillis(1L);
        private static final Logger logger = LoggerFactory.getLogger(HostnameCache.class);
        private final long cacheDuration;
        private volatile String hostname = "unavailable";
        private volatile long expirationTimestamp;
        private AtomicBoolean updateRunning = new AtomicBoolean(false);

        private HostnameCache(long l2) {
            this.cacheDuration = l2;
        }

        public String getHostname() {
            if (this.expirationTimestamp < System.currentTimeMillis() && this.updateRunning.compareAndSet(false, true)) {
                this.updateCache();
            }
            return this.hostname;
        }

        public void updateCache() {
            Callable<Void> callable = new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() {
                    try {
                        HostnameCache.this.hostname = InetAddress.getLocalHost().getCanonicalHostName();
                        HostnameCache.this.expirationTimestamp = System.currentTimeMillis() + HostnameCache.this.cacheDuration;
                    }
                    finally {
                        HostnameCache.this.updateRunning.set(false);
                    }
                    return null;
                }
            };
            try {
                logger.debug("Updating the hostname cache");
                FutureTask<Void> futureTask = new FutureTask<Void>(callable);
                new Thread(futureTask).start();
                futureTask.get(GET_HOSTNAME_TIMEOUT, TimeUnit.MILLISECONDS);
            }
            catch (Exception exception) {
                this.expirationTimestamp = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(1L);
                logger.debug("Localhost hostname lookup failed, keeping the value '{}'. If this persists it may mean your DNS is incorrectly configured and you may want to hardcode your server name: https://docs.sentry.io/clients/java/config/", (Object)this.hostname, (Object)exception);
            }
        }
    }
}

