/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.sl4j.impl;

import me.forseth11.easybackup.dependencies.sl4j.helpers.FormattingTuple;
import me.forseth11.easybackup.dependencies.sl4j.helpers.MarkerIgnoringBase;
import me.forseth11.easybackup.dependencies.sl4j.helpers.MessageFormatter;

public class SimpleLogger
extends MarkerIgnoringBase {
    private static final long serialVersionUID = -6560244151660620173L;
    private static long startTime = System.currentTimeMillis();
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static String INFO_STR = "INFO";
    private static String WARN_STR = "WARN";
    private static String ERROR_STR = "ERROR";

    SimpleLogger(String string) {
        this.name = string;
    }

    public boolean isTraceEnabled() {
        return false;
    }

    public void trace(String string) {
    }

    public void trace(String string, Object object) {
    }

    public void trace(String string, Object object, Object object2) {
    }

    public void trace(String string, Object[] objectArray) {
    }

    public void trace(String string, Throwable throwable) {
    }

    public boolean isDebugEnabled() {
        return false;
    }

    public void debug(String string) {
    }

    public void debug(String string, Object object) {
    }

    public void debug(String string, Object object, Object object2) {
    }

    public void debug(String string, Object[] objectArray) {
    }

    public void debug(String string, Throwable throwable) {
    }

    private void log(String string, String string2, Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        long l2 = System.currentTimeMillis();
        stringBuffer.append(l2 - startTime);
        stringBuffer.append(" [");
        stringBuffer.append(Thread.currentThread().getName());
        stringBuffer.append("] ");
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(this.name);
        stringBuffer.append(" - ");
        stringBuffer.append(string2);
        stringBuffer.append(LINE_SEPARATOR);
        System.err.print(stringBuffer.toString());
        if (throwable != null) {
            throwable.printStackTrace(System.err);
        }
        System.err.flush();
    }

    private void formatAndLog(String string, String string2, Object object, Object object2) {
        FormattingTuple formattingTuple = MessageFormatter.format(string2, object, object2);
        this.log(string, formattingTuple.getMessage(), formattingTuple.getThrowable());
    }

    private void formatAndLog(String string, String string2, Object[] objectArray) {
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat(string2, objectArray);
        this.log(string, formattingTuple.getMessage(), formattingTuple.getThrowable());
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public void info(String string) {
        this.log(INFO_STR, string, null);
    }

    public void info(String string, Object object) {
        this.formatAndLog(INFO_STR, string, object, null);
    }

    public void info(String string, Object object, Object object2) {
        this.formatAndLog(INFO_STR, string, object, object2);
    }

    public void info(String string, Object[] objectArray) {
        this.formatAndLog(INFO_STR, string, objectArray);
    }

    public void info(String string, Throwable throwable) {
        this.log(INFO_STR, string, throwable);
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(String string) {
        this.log(WARN_STR, string, null);
    }

    public void warn(String string, Object object) {
        this.formatAndLog(WARN_STR, string, object, null);
    }

    public void warn(String string, Object object, Object object2) {
        this.formatAndLog(WARN_STR, string, object, object2);
    }

    public void warn(String string, Object[] objectArray) {
        this.formatAndLog(WARN_STR, string, objectArray);
    }

    public void warn(String string, Throwable throwable) {
        this.log(WARN_STR, string, throwable);
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void error(String string) {
        this.log(ERROR_STR, string, null);
    }

    public void error(String string, Object object) {
        this.formatAndLog(ERROR_STR, string, object, null);
    }

    public void error(String string, Object object, Object object2) {
        this.formatAndLog(ERROR_STR, string, object, object2);
    }

    public void error(String string, Object[] objectArray) {
        this.formatAndLog(ERROR_STR, string, objectArray);
    }

    public void error(String string, Throwable throwable) {
        this.log(ERROR_STR, string, throwable);
    }
}

