/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.crypto;

import java.security.SecureRandom;
import me.forseth11.easybackup.dependencies.zip4j.crypto.AesCipherUtil;
import me.forseth11.easybackup.dependencies.zip4j.crypto.Encrypter;
import me.forseth11.easybackup.dependencies.zip4j.crypto.PBKDF2.MacBasedPRF;
import me.forseth11.easybackup.dependencies.zip4j.crypto.engine.AESEngine;
import me.forseth11.easybackup.dependencies.zip4j.exception.ZipException;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.AesKeyStrength;

public class AESEncrypter
implements Encrypter {
    private AESEngine aesEngine;
    private MacBasedPRF mac;
    private final SecureRandom random = new SecureRandom();
    private boolean finished;
    private int nonce = 1;
    private int loopCount = 0;
    private final byte[] iv;
    private final byte[] counterBlock;
    private byte[] derivedPasswordVerifier;
    private byte[] saltBytes;

    public AESEncrypter(char[] cArray, AesKeyStrength aesKeyStrength) {
        if (cArray == null || cArray.length == 0) {
            throw new ZipException("input password is empty or null");
        }
        if (aesKeyStrength != AesKeyStrength.KEY_STRENGTH_128 && aesKeyStrength != AesKeyStrength.KEY_STRENGTH_256) {
            throw new ZipException("Invalid AES key strength");
        }
        this.finished = false;
        this.counterBlock = new byte[16];
        this.iv = new byte[16];
        this.init(cArray, aesKeyStrength);
    }

    private void init(char[] cArray, AesKeyStrength aesKeyStrength) {
        this.saltBytes = this.generateSalt(aesKeyStrength.getSaltLength());
        byte[] byArray = AesCipherUtil.derivePasswordBasedKey(this.saltBytes, cArray, aesKeyStrength);
        this.derivedPasswordVerifier = AesCipherUtil.derivePasswordVerifier(byArray, aesKeyStrength);
        this.aesEngine = AesCipherUtil.getAESEngine(byArray, aesKeyStrength);
        this.mac = AesCipherUtil.getMacBasedPRF(byArray, aesKeyStrength);
    }

    @Override
    public int encryptData(byte[] byArray) {
        if (byArray == null) {
            throw new ZipException("input bytes are null, cannot perform AES encryption");
        }
        return this.encryptData(byArray, 0, byArray.length);
    }

    @Override
    public int encryptData(byte[] byArray, int n2, int n3) {
        if (this.finished) {
            throw new ZipException("AES Encrypter is in finished state (A non 16 byte block has already been passed to encrypter)");
        }
        if (n3 % 16 != 0) {
            this.finished = true;
        }
        for (int i2 = n2; i2 < n2 + n3; i2 += 16) {
            this.loopCount = i2 + 16 <= n2 + n3 ? 16 : n2 + n3 - i2;
            AesCipherUtil.prepareBuffAESIVBytes(this.iv, this.nonce);
            this.aesEngine.processBlock(this.iv, this.counterBlock);
            for (int i3 = 0; i3 < this.loopCount; ++i3) {
                byArray[i2 + i3] = (byte)(byArray[i2 + i3] ^ this.counterBlock[i3]);
            }
            this.mac.update(byArray, i2, this.loopCount);
            ++this.nonce;
        }
        return n3;
    }

    private byte[] generateSalt(int n2) {
        if (n2 != 8 && n2 != 16) {
            throw new ZipException("invalid salt size, cannot generate salt");
        }
        int n3 = n2 == 8 ? 2 : 4;
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = this.random.nextInt();
            byArray[i2 * 4] = (byte)(n4 >> 24);
            byArray[1 + i2 * 4] = (byte)(n4 >> 16);
            byArray[2 + i2 * 4] = (byte)(n4 >> 8);
            byArray[3 + i2 * 4] = (byte)n4;
        }
        return byArray;
    }

    public byte[] getFinalMac() {
        byte[] byArray = this.mac.doFinal();
        byte[] byArray2 = new byte[10];
        System.arraycopy(byArray, 0, byArray2, 0, 10);
        return byArray2;
    }

    public byte[] getDerivedPasswordVerifier() {
        return this.derivedPasswordVerifier;
    }

    public byte[] getSaltBytes() {
        return this.saltBytes;
    }
}

