/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.crypto.PBKDF2;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import me.forseth11.easybackup.dependencies.zip4j.crypto.PBKDF2.PRF;

public class MacBasedPRF
implements PRF {
    private Mac mac;
    private int hLen;
    private String macAlgorithm;

    public MacBasedPRF(String string) {
        this.macAlgorithm = string;
        try {
            this.mac = Mac.getInstance(string);
            this.hLen = this.mac.getMacLength();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }

    @Override
    public byte[] doFinal(byte[] byArray) {
        return this.mac.doFinal(byArray);
    }

    public byte[] doFinal() {
        return this.mac.doFinal();
    }

    @Override
    public int getHLen() {
        return this.hLen;
    }

    @Override
    public void init(byte[] byArray) {
        try {
            this.mac.init(new SecretKeySpec(byArray, this.macAlgorithm));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException(invalidKeyException);
        }
    }

    public void update(byte[] byArray) {
        try {
            this.mac.update(byArray);
        }
        catch (IllegalStateException illegalStateException) {
            throw new RuntimeException(illegalStateException);
        }
    }

    public void update(byte[] byArray, int n2, int n3) {
        try {
            this.mac.update(byArray, n2, n3);
        }
        catch (IllegalStateException illegalStateException) {
            throw new RuntimeException(illegalStateException);
        }
    }
}

