/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.crypto;

import java.security.SecureRandom;
import me.forseth11.easybackup.dependencies.zip4j.crypto.Encrypter;
import me.forseth11.easybackup.dependencies.zip4j.crypto.engine.ZipCryptoEngine;
import me.forseth11.easybackup.dependencies.zip4j.exception.ZipException;

public class StandardEncrypter
implements Encrypter {
    private final ZipCryptoEngine zipCryptoEngine = new ZipCryptoEngine();
    private byte[] headerBytes;

    public StandardEncrypter(char[] cArray, long l2) {
        this.init(cArray, l2);
    }

    private void init(char[] cArray, long l2) {
        if (cArray == null || cArray.length <= 0) {
            throw new ZipException("input password is null or empty, cannot initialize standard encrypter");
        }
        this.zipCryptoEngine.initKeys(cArray);
        this.headerBytes = this.generateRandomBytes();
        this.zipCryptoEngine.initKeys(cArray);
        this.headerBytes[11] = (byte)(l2 >>> 24);
        this.headerBytes[10] = (byte)(l2 >>> 16);
        this.encryptData(this.headerBytes);
    }

    @Override
    public int encryptData(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        return this.encryptData(byArray, 0, byArray.length);
    }

    @Override
    public int encryptData(byte[] byArray, int n2, int n3) {
        if (n3 < 0) {
            throw new ZipException("invalid length specified to decrpyt data");
        }
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            byArray[i2] = this.encryptByte(byArray[i2]);
        }
        return n3;
    }

    protected byte encryptByte(byte by2) {
        byte by3 = (byte)(by2 ^ this.zipCryptoEngine.decryptByte() & 0xFF);
        this.zipCryptoEngine.updateKeys(by2);
        return by3;
    }

    protected byte[] generateRandomBytes() {
        byte[] byArray = new byte[12];
        SecureRandom secureRandom = new SecureRandom();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = this.encryptByte((byte)secureRandom.nextInt(256));
        }
        return byArray;
    }

    public byte[] getHeaderBytes() {
        return this.headerBytes;
    }
}

