/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.io.inputstream;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import me.forseth11.easybackup.dependencies.zip4j.crypto.AESDecrypter;
import me.forseth11.easybackup.dependencies.zip4j.exception.ZipException;
import me.forseth11.easybackup.dependencies.zip4j.io.inputstream.CipherInputStream;
import me.forseth11.easybackup.dependencies.zip4j.io.inputstream.ZipEntryInputStream;
import me.forseth11.easybackup.dependencies.zip4j.model.AESExtraDataRecord;
import me.forseth11.easybackup.dependencies.zip4j.model.LocalFileHeader;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.CompressionMethod;
import me.forseth11.easybackup.dependencies.zip4j.util.Zip4jUtil;

class AesCipherInputStream
extends CipherInputStream<AESDecrypter> {
    private byte[] singleByteBuffer = new byte[1];
    private byte[] aes16ByteBlock = new byte[16];
    private int aes16ByteBlockPointer = 0;
    private int remainingAes16ByteBlockLength = 0;
    private int lengthToRead = 0;
    private int offsetWithAesBlock = 0;
    private int bytesCopiedInThisIteration = 0;
    private int lengthToCopyInThisIteration = 0;
    private int aes16ByteBlockReadLength = 0;

    public AesCipherInputStream(ZipEntryInputStream zipEntryInputStream, LocalFileHeader localFileHeader, char[] cArray, int n2) {
        super(zipEntryInputStream, localFileHeader, cArray, n2);
    }

    @Override
    protected AESDecrypter initializeDecrypter(LocalFileHeader localFileHeader, char[] cArray) {
        return new AESDecrypter(localFileHeader.getAesExtraDataRecord(), cArray, this.getSalt(localFileHeader), this.getPasswordVerifier());
    }

    @Override
    public int read() {
        int n2 = this.read(this.singleByteBuffer);
        if (n2 == -1) {
            return -1;
        }
        return this.singleByteBuffer[0];
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4;
        this.lengthToRead = n3;
        this.offsetWithAesBlock = n2;
        this.bytesCopiedInThisIteration = 0;
        if (this.remainingAes16ByteBlockLength != 0) {
            this.copyBytesFromBuffer(byArray, this.offsetWithAesBlock);
            if (this.bytesCopiedInThisIteration == n3) {
                return this.bytesCopiedInThisIteration;
            }
        }
        if (this.lengthToRead < 16) {
            this.aes16ByteBlockReadLength = super.read(this.aes16ByteBlock, 0, this.aes16ByteBlock.length);
            this.aes16ByteBlockPointer = 0;
            if (this.aes16ByteBlockReadLength == -1) {
                this.remainingAes16ByteBlockLength = 0;
                if (this.bytesCopiedInThisIteration > 0) {
                    return this.bytesCopiedInThisIteration;
                }
                return -1;
            }
            this.remainingAes16ByteBlockLength = this.aes16ByteBlockReadLength;
            this.copyBytesFromBuffer(byArray, this.offsetWithAesBlock);
            if (this.bytesCopiedInThisIteration == n3) {
                return this.bytesCopiedInThisIteration;
            }
        }
        if ((n4 = super.read(byArray, this.offsetWithAesBlock, this.lengthToRead - this.lengthToRead % 16)) == -1) {
            if (this.bytesCopiedInThisIteration > 0) {
                return this.bytesCopiedInThisIteration;
            }
            return -1;
        }
        return n4 + this.bytesCopiedInThisIteration;
    }

    private void copyBytesFromBuffer(byte[] byArray, int n2) {
        this.lengthToCopyInThisIteration = this.lengthToRead < this.remainingAes16ByteBlockLength ? this.lengthToRead : this.remainingAes16ByteBlockLength;
        System.arraycopy(this.aes16ByteBlock, this.aes16ByteBlockPointer, byArray, n2, this.lengthToCopyInThisIteration);
        this.incrementAesByteBlockPointer(this.lengthToCopyInThisIteration);
        this.decrementRemainingAesBytesLength(this.lengthToCopyInThisIteration);
        this.bytesCopiedInThisIteration += this.lengthToCopyInThisIteration;
        this.lengthToRead -= this.lengthToCopyInThisIteration;
        this.offsetWithAesBlock += this.lengthToCopyInThisIteration;
    }

    @Override
    protected void endOfEntryReached(InputStream inputStream) {
        this.verifyContent(this.readStoredMac(inputStream));
    }

    private void verifyContent(byte[] byArray) {
        if (this.getLocalFileHeader().isDataDescriptorExists() && CompressionMethod.DEFLATE.equals((Object)Zip4jUtil.getCompressionMethod(this.getLocalFileHeader()))) {
            return;
        }
        byte[] byArray2 = ((AESDecrypter)this.getDecrypter()).getCalculatedAuthenticationBytes();
        byte[] byArray3 = new byte[10];
        System.arraycopy(byArray2, 0, byArray3, 0, 10);
        if (!Arrays.equals(byArray, byArray3)) {
            throw new IOException("Reached end of data for this entry, but aes verification failed");
        }
    }

    protected byte[] readStoredMac(InputStream inputStream) {
        byte[] byArray = new byte[10];
        int n2 = Zip4jUtil.readFully(inputStream, byArray);
        if (n2 != 10) {
            throw new ZipException("Invalid AES Mac bytes. Could not read sufficient data");
        }
        return byArray;
    }

    private byte[] getSalt(LocalFileHeader localFileHeader) {
        if (localFileHeader.getAesExtraDataRecord() == null) {
            throw new IOException("invalid aes extra data record");
        }
        AESExtraDataRecord aESExtraDataRecord = localFileHeader.getAesExtraDataRecord();
        byte[] byArray = new byte[aESExtraDataRecord.getAesKeyStrength().getSaltLength()];
        this.readRaw(byArray);
        return byArray;
    }

    private byte[] getPasswordVerifier() {
        byte[] byArray = new byte[2];
        this.readRaw(byArray);
        return byArray;
    }

    private void incrementAesByteBlockPointer(int n2) {
        this.aes16ByteBlockPointer += n2;
        if (this.aes16ByteBlockPointer >= 15) {
            this.aes16ByteBlockPointer = 15;
        }
    }

    private void decrementRemainingAesBytesLength(int n2) {
        this.remainingAes16ByteBlockLength -= n2;
        if (this.remainingAes16ByteBlockLength <= 0) {
            this.remainingAes16ByteBlockLength = 0;
        }
    }
}

