/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.io.inputstream;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import me.forseth11.easybackup.dependencies.zip4j.io.inputstream.CipherInputStream;
import me.forseth11.easybackup.dependencies.zip4j.io.inputstream.DecompressedInputStream;

public class InflaterInputStream
extends DecompressedInputStream {
    private Inflater inflater;
    private byte[] buff;
    private byte[] singleByteBuffer = new byte[1];
    private int len;

    public InflaterInputStream(CipherInputStream cipherInputStream, int n2) {
        super(cipherInputStream);
        this.inflater = new Inflater(true);
        this.buff = new byte[n2];
    }

    @Override
    public int read() {
        int n2 = this.read(this.singleByteBuffer);
        if (n2 == -1) {
            return -1;
        }
        return this.singleByteBuffer[0];
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        try {
            int n4;
            while ((n4 = this.inflater.inflate(byArray, n2, n3)) == 0) {
                if (this.inflater.finished() || this.inflater.needsDictionary()) {
                    return -1;
                }
                if (!this.inflater.needsInput()) continue;
                this.fill();
            }
            return n4;
        }
        catch (DataFormatException dataFormatException) {
            throw new IOException(dataFormatException);
        }
    }

    @Override
    public void endOfEntryReached(InputStream inputStream) {
        if (this.inflater != null) {
            this.inflater.end();
            this.inflater = null;
        }
        super.endOfEntryReached(inputStream);
    }

    @Override
    public void pushBackInputStreamIfNecessary(PushbackInputStream pushbackInputStream) {
        int n2 = this.inflater.getRemaining();
        if (n2 > 0) {
            byte[] byArray = this.getLastReadRawDataCache();
            pushbackInputStream.unread(byArray, this.len - n2, n2);
        }
    }

    @Override
    public void close() {
        if (this.inflater != null) {
            this.inflater.end();
        }
        super.close();
    }

    private void fill() {
        this.len = super.read(this.buff, 0, this.buff.length);
        if (this.len == -1) {
            throw new EOFException("Unexpected end of input stream");
        }
        this.inflater.setInput(this.buff, 0, this.len);
    }
}

