/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.io.inputstream;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.RandomAccessFileMode;
import me.forseth11.easybackup.dependencies.zip4j.util.FileUtils;

public class NumberedSplitRandomAccessFile
extends RandomAccessFile {
    private long splitLength;
    private File[] allSortedSplitFiles;
    private RandomAccessFile randomAccessFile;
    private byte[] singleByteBuffer = new byte[1];
    private int currentOpenSplitFileCounter = 0;
    private String rwMode;

    public NumberedSplitRandomAccessFile(String string, String string2) {
        this(new File(string), string2);
    }

    public NumberedSplitRandomAccessFile(File file, String string) {
        this(file, string, FileUtils.getAllSortedNumberedSplitFiles(file));
    }

    public NumberedSplitRandomAccessFile(File file, String string, File[] fileArray) {
        super(file, string);
        super.close();
        if (RandomAccessFileMode.WRITE.getValue().equals(string)) {
            throw new IllegalArgumentException("write mode is not allowed for NumberedSplitRandomAccessFile");
        }
        this.assertAllSplitFilesExist(fileArray);
        this.randomAccessFile = new RandomAccessFile(file, string);
        this.allSortedSplitFiles = fileArray;
        this.splitLength = file.length();
        this.rwMode = string;
    }

    @Override
    public int read() {
        int n2 = this.read(this.singleByteBuffer);
        if (n2 == -1) {
            return -1;
        }
        return this.singleByteBuffer[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4 = this.randomAccessFile.read(byArray, n2, n3);
        if (n4 == -1) {
            if (this.currentOpenSplitFileCounter == this.allSortedSplitFiles.length - 1) {
                return -1;
            }
            this.openRandomAccessFileForIndex(this.currentOpenSplitFileCounter + 1);
            return this.read(byArray, n2, n3);
        }
        return n4;
    }

    @Override
    public void write(int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seek(long l2) {
        int n2 = (int)(l2 / this.splitLength);
        if (n2 != this.currentOpenSplitFileCounter) {
            this.openRandomAccessFileForIndex(n2);
        }
        this.randomAccessFile.seek(l2 - (long)n2 * this.splitLength);
    }

    @Override
    public long getFilePointer() {
        return this.randomAccessFile.getFilePointer();
    }

    @Override
    public long length() {
        return this.randomAccessFile.length();
    }

    public void seekInCurrentPart(long l2) {
        this.randomAccessFile.seek(l2);
    }

    public void openLastSplitFileForReading() {
        this.openRandomAccessFileForIndex(this.allSortedSplitFiles.length - 1);
    }

    private void openRandomAccessFileForIndex(int n2) {
        if (this.currentOpenSplitFileCounter == n2) {
            return;
        }
        if (n2 > this.allSortedSplitFiles.length - 1) {
            throw new IOException("split counter greater than number of split files");
        }
        if (this.randomAccessFile != null) {
            this.randomAccessFile.close();
        }
        this.randomAccessFile = new RandomAccessFile(this.allSortedSplitFiles[n2], this.rwMode);
        this.currentOpenSplitFileCounter = n2;
    }

    private void assertAllSplitFilesExist(File[] fileArray) {
        int n2 = 1;
        for (File file : fileArray) {
            String string = FileUtils.getFileExtension(file);
            try {
                if (n2 != Integer.parseInt(string)) {
                    throw new IOException("Split file number " + n2 + " does not exist");
                }
                ++n2;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Split file extension not in expected format. Found: " + string + " expected of format: .001, .002, etc");
            }
        }
    }
}

