/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.io.inputstream;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import me.forseth11.easybackup.dependencies.zip4j.model.FileHeader;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.RandomAccessFileMode;

public abstract class SplitInputStream
extends InputStream {
    protected RandomAccessFile randomAccessFile;
    protected File zipFile;
    private boolean isSplitZipArchive;
    private int currentSplitFileCounter = 0;
    private byte[] singleByteArray = new byte[1];

    public SplitInputStream(File file, boolean bl2, int n2) {
        this.randomAccessFile = new RandomAccessFile(file, RandomAccessFileMode.READ.getValue());
        this.zipFile = file;
        this.isSplitZipArchive = bl2;
        if (bl2) {
            this.currentSplitFileCounter = n2;
        }
    }

    @Override
    public int read() {
        int n2 = this.read(this.singleByteArray);
        if (n2 == -1) {
            return -1;
        }
        return this.singleByteArray[0];
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4 = this.randomAccessFile.read(byArray, n2, n3);
        if ((n4 != n3 || n4 == -1) && this.isSplitZipArchive) {
            int n5;
            this.openRandomAccessFileForIndex(this.currentSplitFileCounter + 1);
            ++this.currentSplitFileCounter;
            if (n4 < 0) {
                n4 = 0;
            }
            if ((n5 = this.randomAccessFile.read(byArray, n4, n3 - n4)) > 0) {
                n4 += n5;
            }
        }
        return n4;
    }

    public void prepareExtractionForFileHeader(FileHeader fileHeader) {
        if (this.isSplitZipArchive && this.currentSplitFileCounter != fileHeader.getDiskNumberStart()) {
            this.openRandomAccessFileForIndex(fileHeader.getDiskNumberStart());
            this.currentSplitFileCounter = fileHeader.getDiskNumberStart();
        }
        this.randomAccessFile.seek(fileHeader.getOffsetLocalHeader());
    }

    protected void openRandomAccessFileForIndex(int n2) {
        File file = this.getNextSplitFile(n2);
        if (!file.exists()) {
            throw new FileNotFoundException("zip split file does not exist: " + file);
        }
        this.randomAccessFile.close();
        this.randomAccessFile = new RandomAccessFile(file, RandomAccessFileMode.READ.getValue());
    }

    protected abstract File getNextSplitFile(int var1);

    @Override
    public void close() {
        if (this.randomAccessFile != null) {
            this.randomAccessFile.close();
        }
    }
}

