/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.io.inputstream;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.zip.CRC32;
import me.forseth11.easybackup.dependencies.zip4j.exception.ZipException;
import me.forseth11.easybackup.dependencies.zip4j.headers.HeaderReader;
import me.forseth11.easybackup.dependencies.zip4j.headers.HeaderSignature;
import me.forseth11.easybackup.dependencies.zip4j.io.inputstream.AesCipherInputStream;
import me.forseth11.easybackup.dependencies.zip4j.io.inputstream.CipherInputStream;
import me.forseth11.easybackup.dependencies.zip4j.io.inputstream.DecompressedInputStream;
import me.forseth11.easybackup.dependencies.zip4j.io.inputstream.InflaterInputStream;
import me.forseth11.easybackup.dependencies.zip4j.io.inputstream.NoCipherInputStream;
import me.forseth11.easybackup.dependencies.zip4j.io.inputstream.StoreInputStream;
import me.forseth11.easybackup.dependencies.zip4j.io.inputstream.ZipEntryInputStream;
import me.forseth11.easybackup.dependencies.zip4j.io.inputstream.ZipStandardCipherInputStream;
import me.forseth11.easybackup.dependencies.zip4j.model.DataDescriptor;
import me.forseth11.easybackup.dependencies.zip4j.model.ExtraDataRecord;
import me.forseth11.easybackup.dependencies.zip4j.model.FileHeader;
import me.forseth11.easybackup.dependencies.zip4j.model.LocalFileHeader;
import me.forseth11.easybackup.dependencies.zip4j.model.Zip4jConfig;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.AesVersion;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.CompressionMethod;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.EncryptionMethod;
import me.forseth11.easybackup.dependencies.zip4j.util.Zip4jUtil;

public class ZipInputStream
extends InputStream {
    private PushbackInputStream inputStream;
    private DecompressedInputStream decompressedInputStream;
    private HeaderReader headerReader = new HeaderReader();
    private char[] password;
    private LocalFileHeader localFileHeader;
    private CRC32 crc32 = new CRC32();
    private byte[] endOfEntryBuffer;
    private boolean canSkipExtendedLocalFileHeader = false;
    private Zip4jConfig zip4jConfig;

    public ZipInputStream(InputStream inputStream) {
        this(inputStream, null, (Charset)null);
    }

    public ZipInputStream(InputStream inputStream, Charset charset) {
        this(inputStream, null, charset);
    }

    public ZipInputStream(InputStream inputStream, char[] cArray) {
        this(inputStream, cArray, (Charset)null);
    }

    public ZipInputStream(InputStream inputStream, char[] cArray, Charset charset) {
        this(inputStream, cArray, new Zip4jConfig(charset, 4096));
    }

    public ZipInputStream(InputStream inputStream, char[] cArray, Zip4jConfig zip4jConfig) {
        if (zip4jConfig.getBufferSize() < 512) {
            throw new IllegalArgumentException("Buffer size cannot be less than 512 bytes");
        }
        this.inputStream = new PushbackInputStream(inputStream, zip4jConfig.getBufferSize());
        this.password = cArray;
        this.zip4jConfig = zip4jConfig;
    }

    public LocalFileHeader getNextEntry() {
        return this.getNextEntry(null);
    }

    public LocalFileHeader getNextEntry(FileHeader fileHeader) {
        if (this.localFileHeader != null) {
            this.readUntilEndOfEntry();
        }
        this.localFileHeader = this.headerReader.readLocalFileHeader(this.inputStream, this.zip4jConfig.getCharset());
        if (this.localFileHeader == null) {
            return null;
        }
        this.verifyLocalFileHeader(this.localFileHeader);
        this.crc32.reset();
        if (fileHeader != null) {
            this.localFileHeader.setCrc(fileHeader.getCrc());
            this.localFileHeader.setCompressedSize(fileHeader.getCompressedSize());
            this.localFileHeader.setUncompressedSize(fileHeader.getUncompressedSize());
            this.localFileHeader.setDirectory(fileHeader.isDirectory());
            this.canSkipExtendedLocalFileHeader = true;
        } else {
            this.canSkipExtendedLocalFileHeader = false;
        }
        this.decompressedInputStream = this.initializeEntryInputStream(this.localFileHeader);
        return this.localFileHeader;
    }

    @Override
    public int read() {
        byte[] byArray = new byte[1];
        int n2 = this.read(byArray);
        if (n2 == -1) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("Negative read length");
        }
        if (n3 == 0) {
            return 0;
        }
        if (this.localFileHeader == null) {
            return -1;
        }
        try {
            int n4 = this.decompressedInputStream.read(byArray, n2, n3);
            if (n4 == -1) {
                this.endOfCompressedDataReached();
            } else {
                this.crc32.update(byArray, n2, n4);
            }
            return n4;
        }
        catch (IOException iOException) {
            if (this.isEncryptionMethodZipStandard(this.localFileHeader)) {
                throw new ZipException(iOException.getMessage(), iOException.getCause(), ZipException.Type.WRONG_PASSWORD);
            }
            throw iOException;
        }
    }

    @Override
    public void close() {
        if (this.decompressedInputStream != null) {
            this.decompressedInputStream.close();
        }
    }

    private void endOfCompressedDataReached() {
        this.decompressedInputStream.pushBackInputStreamIfNecessary(this.inputStream);
        this.decompressedInputStream.endOfEntryReached(this.inputStream);
        this.readExtendedLocalFileHeaderIfPresent();
        this.verifyCrc();
        this.resetFields();
    }

    private DecompressedInputStream initializeEntryInputStream(LocalFileHeader localFileHeader) {
        ZipEntryInputStream zipEntryInputStream = new ZipEntryInputStream(this.inputStream, this.getCompressedSize(localFileHeader));
        CipherInputStream cipherInputStream = this.initializeCipherInputStream(zipEntryInputStream, localFileHeader);
        return this.initializeDecompressorForThisEntry(cipherInputStream, localFileHeader);
    }

    private CipherInputStream initializeCipherInputStream(ZipEntryInputStream zipEntryInputStream, LocalFileHeader localFileHeader) {
        if (!localFileHeader.isEncrypted()) {
            return new NoCipherInputStream(zipEntryInputStream, localFileHeader, this.password, this.zip4jConfig.getBufferSize());
        }
        if (localFileHeader.getEncryptionMethod() == EncryptionMethod.AES) {
            return new AesCipherInputStream(zipEntryInputStream, localFileHeader, this.password, this.zip4jConfig.getBufferSize());
        }
        if (localFileHeader.getEncryptionMethod() == EncryptionMethod.ZIP_STANDARD) {
            return new ZipStandardCipherInputStream(zipEntryInputStream, localFileHeader, this.password, this.zip4jConfig.getBufferSize());
        }
        String string = String.format("Entry [%s] Strong Encryption not supported", localFileHeader.getFileName());
        throw new ZipException(string, ZipException.Type.UNSUPPORTED_ENCRYPTION);
    }

    private DecompressedInputStream initializeDecompressorForThisEntry(CipherInputStream cipherInputStream, LocalFileHeader localFileHeader) {
        CompressionMethod compressionMethod = Zip4jUtil.getCompressionMethod(localFileHeader);
        if (compressionMethod == CompressionMethod.DEFLATE) {
            return new InflaterInputStream(cipherInputStream, this.zip4jConfig.getBufferSize());
        }
        return new StoreInputStream(cipherInputStream);
    }

    private void readExtendedLocalFileHeaderIfPresent() {
        if (!this.localFileHeader.isDataDescriptorExists() || this.canSkipExtendedLocalFileHeader) {
            return;
        }
        DataDescriptor dataDescriptor = this.headerReader.readDataDescriptor(this.inputStream, this.checkIfZip64ExtraDataRecordPresentInLFH(this.localFileHeader.getExtraDataRecords()));
        this.localFileHeader.setCompressedSize(dataDescriptor.getCompressedSize());
        this.localFileHeader.setUncompressedSize(dataDescriptor.getUncompressedSize());
        this.localFileHeader.setCrc(dataDescriptor.getCrc());
    }

    private void verifyLocalFileHeader(LocalFileHeader localFileHeader) {
        if (!this.isEntryDirectory(localFileHeader.getFileName()) && localFileHeader.getCompressionMethod() == CompressionMethod.STORE && localFileHeader.getUncompressedSize() < 0L) {
            throw new IOException("Invalid local file header for: " + localFileHeader.getFileName() + ". Uncompressed size has to be set for entry of compression type store which is not a directory");
        }
    }

    private boolean checkIfZip64ExtraDataRecordPresentInLFH(List<ExtraDataRecord> list) {
        if (list == null) {
            return false;
        }
        for (ExtraDataRecord extraDataRecord : list) {
            if (extraDataRecord.getHeader() != HeaderSignature.ZIP64_EXTRA_FIELD_SIGNATURE.getValue()) continue;
            return true;
        }
        return false;
    }

    private void verifyCrc() {
        if (this.localFileHeader.getEncryptionMethod() == EncryptionMethod.AES && this.localFileHeader.getAesExtraDataRecord().getAesVersion().equals((Object)AesVersion.TWO)) {
            return;
        }
        if (this.localFileHeader.getCrc() != this.crc32.getValue()) {
            ZipException.Type type = ZipException.Type.CHECKSUM_MISMATCH;
            if (this.isEncryptionMethodZipStandard(this.localFileHeader)) {
                type = ZipException.Type.WRONG_PASSWORD;
            }
            throw new ZipException("Reached end of entry, but crc verification failed for " + this.localFileHeader.getFileName(), type);
        }
    }

    private void resetFields() {
        this.localFileHeader = null;
        this.crc32.reset();
    }

    private boolean isEntryDirectory(String string) {
        return string.endsWith("/") || string.endsWith("\\");
    }

    private long getCompressedSize(LocalFileHeader localFileHeader) {
        if (Zip4jUtil.getCompressionMethod(localFileHeader).equals((Object)CompressionMethod.STORE)) {
            return localFileHeader.getUncompressedSize();
        }
        if (localFileHeader.isDataDescriptorExists() && !this.canSkipExtendedLocalFileHeader) {
            return -1L;
        }
        return localFileHeader.getCompressedSize() - (long)this.getEncryptionHeaderSize(localFileHeader);
    }

    private int getEncryptionHeaderSize(LocalFileHeader localFileHeader) {
        if (!localFileHeader.isEncrypted()) {
            return 0;
        }
        if (localFileHeader.getEncryptionMethod().equals((Object)EncryptionMethod.AES)) {
            return 12 + localFileHeader.getAesExtraDataRecord().getAesKeyStrength().getSaltLength();
        }
        if (localFileHeader.getEncryptionMethod().equals((Object)EncryptionMethod.ZIP_STANDARD)) {
            return 12;
        }
        return 0;
    }

    private void readUntilEndOfEntry() {
        if (this.localFileHeader.isDirectory() || this.localFileHeader.getCompressedSize() == 0L && !this.localFileHeader.isDataDescriptorExists()) {
            return;
        }
        if (this.endOfEntryBuffer == null) {
            this.endOfEntryBuffer = new byte[512];
        }
        while (this.read(this.endOfEntryBuffer) != -1) {
        }
    }

    private boolean isEncryptionMethodZipStandard(LocalFileHeader localFileHeader) {
        return localFileHeader.isEncrypted() && EncryptionMethod.ZIP_STANDARD.equals((Object)localFileHeader.getEncryptionMethod());
    }
}

