/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.io.outputstream;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import me.forseth11.easybackup.dependencies.zip4j.exception.ZipException;
import me.forseth11.easybackup.dependencies.zip4j.headers.HeaderSignature;
import me.forseth11.easybackup.dependencies.zip4j.io.outputstream.OutputStreamWithSplitZipSupport;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.RandomAccessFileMode;
import me.forseth11.easybackup.dependencies.zip4j.util.FileUtils;
import me.forseth11.easybackup.dependencies.zip4j.util.RawIO;

public class SplitOutputStream
extends OutputStream
implements OutputStreamWithSplitZipSupport {
    private RandomAccessFile raf;
    private long splitLength;
    private File zipFile;
    private int currSplitFileCounter;
    private long bytesWrittenForThisPart;
    private RawIO rawIO = new RawIO();

    public SplitOutputStream(File file) {
        this(file, -1L);
    }

    public SplitOutputStream(File file, long l2) {
        if (l2 >= 0L && l2 < 65536L) {
            throw new ZipException("split length less than minimum allowed split length of 65536 Bytes");
        }
        this.raf = new RandomAccessFile(file, RandomAccessFileMode.WRITE.getValue());
        this.splitLength = l2;
        this.zipFile = file;
        this.currSplitFileCounter = 0;
        this.bytesWrittenForThisPart = 0L;
    }

    @Override
    public void write(int n2) {
        this.write(new byte[]{(byte)n2});
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        if (n3 <= 0) {
            return;
        }
        if (this.splitLength == -1L) {
            this.raf.write(byArray, n2, n3);
            this.bytesWrittenForThisPart += (long)n3;
            return;
        }
        if (this.bytesWrittenForThisPart >= this.splitLength) {
            this.startNextSplitFile();
            this.raf.write(byArray, n2, n3);
            this.bytesWrittenForThisPart = n3;
        } else if (this.bytesWrittenForThisPart + (long)n3 > this.splitLength) {
            if (this.isHeaderData(byArray)) {
                this.startNextSplitFile();
                this.raf.write(byArray, n2, n3);
                this.bytesWrittenForThisPart = n3;
            } else {
                this.raf.write(byArray, n2, (int)(this.splitLength - this.bytesWrittenForThisPart));
                this.startNextSplitFile();
                this.raf.write(byArray, n2 + (int)(this.splitLength - this.bytesWrittenForThisPart), (int)((long)n3 - (this.splitLength - this.bytesWrittenForThisPart)));
                this.bytesWrittenForThisPart = (long)n3 - (this.splitLength - this.bytesWrittenForThisPart);
            }
        } else {
            this.raf.write(byArray, n2, n3);
            this.bytesWrittenForThisPart += (long)n3;
        }
    }

    private void startNextSplitFile() {
        String string = FileUtils.getZipFileNameWithoutExtension(this.zipFile.getName());
        String string2 = this.zipFile.getAbsolutePath();
        String string3 = this.zipFile.getParent() == null ? "" : this.zipFile.getParent() + System.getProperty("file.separator");
        String string4 = ".z0" + (this.currSplitFileCounter + 1);
        if (this.currSplitFileCounter >= 9) {
            string4 = ".z" + (this.currSplitFileCounter + 1);
        }
        File file = new File(string3 + string + string4);
        this.raf.close();
        if (file.exists()) {
            throw new IOException("split file: " + file.getName() + " already exists in the current directory, cannot rename this file");
        }
        if (!this.zipFile.renameTo(file)) {
            throw new IOException("cannot rename newly created split file");
        }
        this.zipFile = new File(string2);
        this.raf = new RandomAccessFile(this.zipFile, RandomAccessFileMode.WRITE.getValue());
        ++this.currSplitFileCounter;
    }

    private boolean isHeaderData(byte[] byArray) {
        int n2 = this.rawIO.readIntLittleEndian(byArray);
        for (HeaderSignature headerSignature : HeaderSignature.values()) {
            if (headerSignature == HeaderSignature.SPLIT_ZIP || headerSignature.getValue() != (long)n2) continue;
            return true;
        }
        return false;
    }

    public boolean checkBufferSizeAndStartNextSplitFile(int n2) {
        if (n2 < 0) {
            throw new ZipException("negative buffersize for checkBufferSizeAndStartNextSplitFile");
        }
        if (!this.isBufferSizeFitForCurrSplitFile(n2)) {
            try {
                this.startNextSplitFile();
                this.bytesWrittenForThisPart = 0L;
                return true;
            }
            catch (IOException iOException) {
                throw new ZipException(iOException);
            }
        }
        return false;
    }

    private boolean isBufferSizeFitForCurrSplitFile(int n2) {
        if (this.splitLength >= 65536L) {
            return this.bytesWrittenForThisPart + (long)n2 <= this.splitLength;
        }
        return true;
    }

    public void seek(long l2) {
        this.raf.seek(l2);
    }

    public int skipBytes(int n2) {
        return this.raf.skipBytes(n2);
    }

    @Override
    public void close() {
        this.raf.close();
    }

    @Override
    public long getFilePointer() {
        return this.raf.getFilePointer();
    }

    public boolean isSplitZipFile() {
        return this.splitLength != -1L;
    }

    public long getSplitLength() {
        return this.splitLength;
    }

    @Override
    public int getCurrentSplitFileCounter() {
        return this.currSplitFileCounter;
    }
}

