/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.io.outputstream;

import java.io.OutputStream;

class ZipEntryOutputStream
extends OutputStream {
    private long numberOfBytesWrittenForThisEntry = 0L;
    private OutputStream outputStream;
    private boolean entryClosed;

    public ZipEntryOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.entryClosed = false;
    }

    @Override
    public void write(int n2) {
        this.write(new byte[]{(byte)n2});
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        if (this.entryClosed) {
            throw new IllegalStateException("ZipEntryOutputStream is closed");
        }
        this.outputStream.write(byArray, n2, n3);
        this.numberOfBytesWrittenForThisEntry += (long)n3;
    }

    public void closeEntry() {
        this.entryClosed = true;
    }

    public long getNumberOfBytesWrittenForThisEntry() {
        return this.numberOfBytesWrittenForThisEntry;
    }

    @Override
    public void close() {
    }
}

