/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.tasks;

import java.io.File;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import me.forseth11.easybackup.dependencies.zip4j.exception.ZipException;
import me.forseth11.easybackup.dependencies.zip4j.headers.HeaderUtil;
import me.forseth11.easybackup.dependencies.zip4j.model.FileHeader;
import me.forseth11.easybackup.dependencies.zip4j.model.ZipModel;
import me.forseth11.easybackup.dependencies.zip4j.progress.ProgressMonitor;
import me.forseth11.easybackup.dependencies.zip4j.tasks.AsyncZipTask;
import me.forseth11.easybackup.dependencies.zip4j.util.FileUtils;

abstract class AbstractModifyFileTask<T>
extends AsyncZipTask<T> {
    AbstractModifyFileTask(AsyncZipTask.AsyncTaskParameters asyncTaskParameters) {
        super(asyncTaskParameters);
    }

    File getTemporaryFile(String string) {
        Random random = new Random();
        File file = new File(string + random.nextInt(10000));
        while (file.exists()) {
            file = new File(string + random.nextInt(10000));
        }
        return file;
    }

    void updateOffsetsForAllSubsequentFileHeaders(List<FileHeader> list, ZipModel zipModel, FileHeader fileHeader, long l2) {
        int n2 = this.getIndexOfFileHeader(list, fileHeader);
        if (n2 == -1) {
            throw new ZipException("Could not locate modified file header in zipModel");
        }
        for (int i2 = n2 + 1; i2 < list.size(); ++i2) {
            FileHeader fileHeader2 = list.get(i2);
            fileHeader2.setOffsetLocalHeader(fileHeader2.getOffsetLocalHeader() + l2);
            if (!zipModel.isZip64Format() || fileHeader2.getZip64ExtendedInfo() == null || fileHeader2.getZip64ExtendedInfo().getOffsetLocalHeader() == -1L) continue;
            fileHeader2.getZip64ExtendedInfo().setOffsetLocalHeader(fileHeader2.getZip64ExtendedInfo().getOffsetLocalHeader() + l2);
        }
    }

    void cleanupFile(boolean bl2, File file, File file2) {
        if (bl2) {
            this.restoreFileName(file, file2);
        } else if (!file2.delete()) {
            throw new ZipException("Could not delete temporary file");
        }
    }

    long copyFile(RandomAccessFile randomAccessFile, OutputStream outputStream, long l2, long l3, ProgressMonitor progressMonitor, int n2) {
        FileUtils.copyFile(randomAccessFile, outputStream, l2, l2 + l3, progressMonitor, n2);
        return l3;
    }

    List<FileHeader> cloneAndSortFileHeadersByOffset(List<FileHeader> list) {
        ArrayList<FileHeader> arrayList = new ArrayList<FileHeader>(list);
        Collections.sort(arrayList, (fileHeader, fileHeader2) -> {
            if (fileHeader.getFileName().equals(fileHeader2.getFileName())) {
                return 0;
            }
            return fileHeader.getOffsetLocalHeader() < fileHeader2.getOffsetLocalHeader() ? -1 : 1;
        });
        return arrayList;
    }

    long getOffsetOfNextEntry(List<FileHeader> list, FileHeader fileHeader, ZipModel zipModel) {
        int n2 = this.getIndexOfFileHeader(list, fileHeader);
        if (n2 == list.size() - 1) {
            return HeaderUtil.getOffsetStartOfCentralDirectory(zipModel);
        }
        return list.get(n2 + 1).getOffsetLocalHeader();
    }

    private void restoreFileName(File file, File file2) {
        if (file.delete()) {
            if (!file2.renameTo(file)) {
                throw new ZipException("cannot rename modified zip file");
            }
        } else {
            throw new ZipException("cannot delete old zip file");
        }
    }

    private int getIndexOfFileHeader(List<FileHeader> list, FileHeader fileHeader) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            FileHeader fileHeader2 = list.get(i2);
            if (!fileHeader2.equals(fileHeader)) continue;
            return i2;
        }
        throw new ZipException("Could not find file header in list of central directory file headers");
    }
}

