/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.tasks;

import java.io.InputStream;
import me.forseth11.easybackup.dependencies.zip4j.exception.ZipException;
import me.forseth11.easybackup.dependencies.zip4j.headers.HeaderUtil;
import me.forseth11.easybackup.dependencies.zip4j.headers.HeaderWriter;
import me.forseth11.easybackup.dependencies.zip4j.io.outputstream.SplitOutputStream;
import me.forseth11.easybackup.dependencies.zip4j.io.outputstream.ZipOutputStream;
import me.forseth11.easybackup.dependencies.zip4j.model.FileHeader;
import me.forseth11.easybackup.dependencies.zip4j.model.Zip4jConfig;
import me.forseth11.easybackup.dependencies.zip4j.model.ZipModel;
import me.forseth11.easybackup.dependencies.zip4j.model.ZipParameters;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.CompressionMethod;
import me.forseth11.easybackup.dependencies.zip4j.progress.ProgressMonitor;
import me.forseth11.easybackup.dependencies.zip4j.tasks.AbstractAddFileToZipTask;
import me.forseth11.easybackup.dependencies.zip4j.tasks.AbstractZipTaskParameters;
import me.forseth11.easybackup.dependencies.zip4j.tasks.AsyncZipTask;
import me.forseth11.easybackup.dependencies.zip4j.util.Zip4jUtil;

public class AddStreamToZipTask
extends AbstractAddFileToZipTask<AddStreamToZipTaskParameters> {
    public AddStreamToZipTask(ZipModel zipModel, char[] cArray, HeaderWriter headerWriter, AsyncZipTask.AsyncTaskParameters asyncTaskParameters) {
        super(zipModel, cArray, headerWriter, asyncTaskParameters);
    }

    @Override
    protected void executeTask(AddStreamToZipTaskParameters addStreamToZipTaskParameters, ProgressMonitor progressMonitor) {
        this.verifyZipParameters(addStreamToZipTaskParameters.zipParameters);
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(addStreamToZipTaskParameters.zipParameters.getFileNameInZip())) {
            throw new ZipException("fileNameInZip has to be set in zipParameters when adding stream");
        }
        this.removeFileIfExists(this.getZipModel(), addStreamToZipTaskParameters.zip4jConfig, addStreamToZipTaskParameters.zipParameters.getFileNameInZip(), progressMonitor);
        addStreamToZipTaskParameters.zipParameters.setWriteExtendedLocalFileHeader(true);
        if (addStreamToZipTaskParameters.zipParameters.getCompressionMethod().equals((Object)CompressionMethod.STORE)) {
            addStreamToZipTaskParameters.zipParameters.setEntrySize(0L);
        }
        try (SplitOutputStream splitOutputStream = new SplitOutputStream(this.getZipModel().getZipFile(), this.getZipModel().getSplitLength());
             ZipOutputStream zipOutputStream = this.initializeOutputStream(splitOutputStream, addStreamToZipTaskParameters.zip4jConfig);){
            FileHeader fileHeader;
            byte[] byArray = new byte[addStreamToZipTaskParameters.zip4jConfig.getBufferSize()];
            ZipParameters zipParameters = addStreamToZipTaskParameters.zipParameters;
            zipOutputStream.putNextEntry(zipParameters);
            if (!zipParameters.getFileNameInZip().endsWith("/") && !zipParameters.getFileNameInZip().endsWith("\\")) {
                int n2;
                while ((n2 = addStreamToZipTaskParameters.inputStream.read(byArray)) != -1) {
                    zipOutputStream.write(byArray, 0, n2);
                }
            }
            if ((fileHeader = zipOutputStream.closeEntry()).getCompressionMethod().equals((Object)CompressionMethod.STORE)) {
                this.updateLocalFileHeader(fileHeader, splitOutputStream);
            }
        }
    }

    @Override
    protected long calculateTotalWork(AddStreamToZipTaskParameters addStreamToZipTaskParameters) {
        return 0L;
    }

    private void removeFileIfExists(ZipModel zipModel, Zip4jConfig zip4jConfig, String string, ProgressMonitor progressMonitor) {
        FileHeader fileHeader = HeaderUtil.getFileHeader(zipModel, string);
        if (fileHeader != null) {
            this.removeFile(fileHeader, progressMonitor, zip4jConfig);
        }
    }

    public static class AddStreamToZipTaskParameters
    extends AbstractZipTaskParameters {
        private InputStream inputStream;
        private ZipParameters zipParameters;

        public AddStreamToZipTaskParameters(InputStream inputStream, ZipParameters zipParameters, Zip4jConfig zip4jConfig) {
            super(zip4jConfig);
            this.inputStream = inputStream;
            this.zipParameters = zipParameters;
        }
    }
}

