/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.tasks;

import java.io.InputStream;
import me.forseth11.easybackup.dependencies.zip4j.headers.HeaderUtil;
import me.forseth11.easybackup.dependencies.zip4j.io.inputstream.SplitInputStream;
import me.forseth11.easybackup.dependencies.zip4j.io.inputstream.ZipInputStream;
import me.forseth11.easybackup.dependencies.zip4j.model.FileHeader;
import me.forseth11.easybackup.dependencies.zip4j.model.UnzipParameters;
import me.forseth11.easybackup.dependencies.zip4j.model.Zip4jConfig;
import me.forseth11.easybackup.dependencies.zip4j.model.ZipModel;
import me.forseth11.easybackup.dependencies.zip4j.progress.ProgressMonitor;
import me.forseth11.easybackup.dependencies.zip4j.tasks.AbstractExtractFileTask;
import me.forseth11.easybackup.dependencies.zip4j.tasks.AbstractZipTaskParameters;
import me.forseth11.easybackup.dependencies.zip4j.tasks.AsyncZipTask;
import me.forseth11.easybackup.dependencies.zip4j.util.UnzipUtil;

public class ExtractAllFilesTask
extends AbstractExtractFileTask<ExtractAllFilesTaskParameters> {
    private char[] password;
    private SplitInputStream splitInputStream;

    public ExtractAllFilesTask(ZipModel zipModel, char[] cArray, UnzipParameters unzipParameters, AsyncZipTask.AsyncTaskParameters asyncTaskParameters) {
        super(zipModel, unzipParameters, asyncTaskParameters);
        this.password = cArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeTask(ExtractAllFilesTaskParameters extractAllFilesTaskParameters, ProgressMonitor progressMonitor) {
        try (ZipInputStream zipInputStream = this.prepareZipInputStream(extractAllFilesTaskParameters.zip4jConfig);){
            for (FileHeader fileHeader : this.getZipModel().getCentralDirectory().getFileHeaders()) {
                if (fileHeader.getFileName().startsWith("__MACOSX")) {
                    progressMonitor.updateWorkCompleted(fileHeader.getUncompressedSize());
                    continue;
                }
                this.splitInputStream.prepareExtractionForFileHeader(fileHeader);
                byte[] byArray = new byte[extractAllFilesTaskParameters.zip4jConfig.getBufferSize()];
                this.extractFile(zipInputStream, fileHeader, extractAllFilesTaskParameters.outputPath, null, progressMonitor, byArray);
                this.verifyIfTaskIsCancelled();
            }
        }
        finally {
            if (this.splitInputStream != null) {
                this.splitInputStream.close();
            }
        }
    }

    @Override
    protected long calculateTotalWork(ExtractAllFilesTaskParameters extractAllFilesTaskParameters) {
        return HeaderUtil.getTotalUncompressedSizeOfAllFileHeaders(this.getZipModel().getCentralDirectory().getFileHeaders());
    }

    private ZipInputStream prepareZipInputStream(Zip4jConfig zip4jConfig) {
        this.splitInputStream = UnzipUtil.createSplitInputStream(this.getZipModel());
        FileHeader fileHeader = this.getFirstFileHeader(this.getZipModel());
        if (fileHeader != null) {
            this.splitInputStream.prepareExtractionForFileHeader(fileHeader);
        }
        return new ZipInputStream((InputStream)this.splitInputStream, this.password, zip4jConfig);
    }

    private FileHeader getFirstFileHeader(ZipModel zipModel) {
        if (zipModel.getCentralDirectory() == null || zipModel.getCentralDirectory().getFileHeaders() == null || zipModel.getCentralDirectory().getFileHeaders().size() == 0) {
            return null;
        }
        return zipModel.getCentralDirectory().getFileHeaders().get(0);
    }

    public static class ExtractAllFilesTaskParameters
    extends AbstractZipTaskParameters {
        private String outputPath;

        public ExtractAllFilesTaskParameters(String string, Zip4jConfig zip4jConfig) {
            super(zip4jConfig);
            this.outputPath = string;
        }
    }
}

