/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.tasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.List;
import me.forseth11.easybackup.dependencies.zip4j.exception.ZipException;
import me.forseth11.easybackup.dependencies.zip4j.headers.HeaderSignature;
import me.forseth11.easybackup.dependencies.zip4j.headers.HeaderWriter;
import me.forseth11.easybackup.dependencies.zip4j.model.EndOfCentralDirectoryRecord;
import me.forseth11.easybackup.dependencies.zip4j.model.FileHeader;
import me.forseth11.easybackup.dependencies.zip4j.model.Zip4jConfig;
import me.forseth11.easybackup.dependencies.zip4j.model.Zip64EndOfCentralDirectoryLocator;
import me.forseth11.easybackup.dependencies.zip4j.model.Zip64EndOfCentralDirectoryRecord;
import me.forseth11.easybackup.dependencies.zip4j.model.ZipModel;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.RandomAccessFileMode;
import me.forseth11.easybackup.dependencies.zip4j.progress.ProgressMonitor;
import me.forseth11.easybackup.dependencies.zip4j.tasks.AbstractZipTaskParameters;
import me.forseth11.easybackup.dependencies.zip4j.tasks.AsyncZipTask;
import me.forseth11.easybackup.dependencies.zip4j.util.FileUtils;
import me.forseth11.easybackup.dependencies.zip4j.util.RawIO;

public class MergeSplitZipFileTask
extends AsyncZipTask<MergeSplitZipFileTaskParameters> {
    private ZipModel zipModel;
    private RawIO rawIO = new RawIO();

    public MergeSplitZipFileTask(ZipModel zipModel, AsyncZipTask.AsyncTaskParameters asyncTaskParameters) {
        super(asyncTaskParameters);
        this.zipModel = zipModel;
    }

    @Override
    protected void executeTask(MergeSplitZipFileTaskParameters mergeSplitZipFileTaskParameters, ProgressMonitor progressMonitor) {
        if (!this.zipModel.isSplitArchive()) {
            ZipException zipException = new ZipException("archive not a split zip file");
            progressMonitor.endProgressMonitor(zipException);
            throw zipException;
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(mergeSplitZipFileTaskParameters.outputZipFile);){
            long l2 = 0L;
            int n2 = this.zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDisk();
            if (n2 <= 0) {
                throw new ZipException("zip archive not a split zip file");
            }
            int n3 = 0;
            for (int i2 = 0; i2 <= n2; ++i2) {
                try (RandomAccessFile randomAccessFile = this.createSplitZipFileStream(this.zipModel, i2);){
                    int n4 = 0;
                    long l3 = randomAccessFile.length();
                    if (i2 == 0) {
                        if ((long)this.rawIO.readIntLittleEndian(randomAccessFile) == HeaderSignature.SPLIT_ZIP.getValue()) {
                            n3 = 4;
                            n4 = 4;
                        } else {
                            randomAccessFile.seek(0L);
                        }
                    }
                    if (i2 == n2) {
                        l3 = this.zipModel.getEndOfCentralDirectoryRecord().getOffsetOfStartOfCentralDirectory();
                    }
                    FileUtils.copyFile(randomAccessFile, fileOutputStream, n4, l3, progressMonitor, mergeSplitZipFileTaskParameters.zip4jConfig.getBufferSize());
                    this.updateFileHeaderOffsetsForIndex(this.zipModel.getCentralDirectory().getFileHeaders(), i2 == 0 ? 0L : (l2 += l3 - (long)n4), i2, n3);
                    this.verifyIfTaskIsCancelled();
                    continue;
                }
            }
            this.updateHeadersForMergeSplitFileAction(this.zipModel, l2, fileOutputStream, mergeSplitZipFileTaskParameters.zip4jConfig.getCharset());
            progressMonitor.endProgressMonitor();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ZipException(cloneNotSupportedException);
        }
    }

    @Override
    protected long calculateTotalWork(MergeSplitZipFileTaskParameters mergeSplitZipFileTaskParameters) {
        if (!this.zipModel.isSplitArchive()) {
            return 0L;
        }
        long l2 = 0L;
        for (int i2 = 0; i2 <= this.zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDisk(); ++i2) {
            l2 += this.getNextSplitZipFile(this.zipModel, i2).length();
        }
        return l2;
    }

    private void updateFileHeaderOffsetsForIndex(List<FileHeader> list, long l2, int n2, int n3) {
        for (FileHeader fileHeader : list) {
            if (fileHeader.getDiskNumberStart() != n2) continue;
            fileHeader.setOffsetLocalHeader(fileHeader.getOffsetLocalHeader() + l2 - (long)n3);
            fileHeader.setDiskNumberStart(0);
        }
    }

    private File getNextSplitZipFile(ZipModel zipModel, int n2) {
        if (n2 == zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDisk()) {
            return zipModel.getZipFile();
        }
        String string = ".z0";
        if (n2 >= 9) {
            string = ".z";
        }
        String string2 = zipModel.getZipFile().getPath();
        String string3 = zipModel.getZipFile().getPath().substring(0, string2.lastIndexOf(".")) + string + (n2 + 1);
        return new File(string3);
    }

    private RandomAccessFile createSplitZipFileStream(ZipModel zipModel, int n2) {
        File file = this.getNextSplitZipFile(zipModel, n2);
        return new RandomAccessFile(file, RandomAccessFileMode.READ.getValue());
    }

    private void updateHeadersForMergeSplitFileAction(ZipModel zipModel, long l2, OutputStream outputStream, Charset charset) {
        ZipModel zipModel2 = (ZipModel)zipModel.clone();
        zipModel2.getEndOfCentralDirectoryRecord().setOffsetOfStartOfCentralDirectory(l2);
        this.updateSplitZipModel(zipModel2, l2);
        HeaderWriter headerWriter = new HeaderWriter();
        headerWriter.finalizeZipFileWithoutValidations(zipModel2, outputStream, charset);
    }

    private void updateSplitZipModel(ZipModel zipModel, long l2) {
        zipModel.setSplitArchive(false);
        this.updateSplitEndCentralDirectory(zipModel);
        if (zipModel.isZip64Format()) {
            this.updateSplitZip64EndCentralDirLocator(zipModel, l2);
            this.updateSplitZip64EndCentralDirRec(zipModel, l2);
        }
    }

    private void updateSplitEndCentralDirectory(ZipModel zipModel) {
        int n2 = zipModel.getCentralDirectory().getFileHeaders().size();
        EndOfCentralDirectoryRecord endOfCentralDirectoryRecord = zipModel.getEndOfCentralDirectoryRecord();
        endOfCentralDirectoryRecord.setNumberOfThisDisk(0);
        endOfCentralDirectoryRecord.setNumberOfThisDiskStartOfCentralDir(0);
        endOfCentralDirectoryRecord.setTotalNumberOfEntriesInCentralDirectory(n2);
        endOfCentralDirectoryRecord.setTotalNumberOfEntriesInCentralDirectoryOnThisDisk(n2);
    }

    private void updateSplitZip64EndCentralDirLocator(ZipModel zipModel, long l2) {
        if (zipModel.getZip64EndOfCentralDirectoryLocator() == null) {
            return;
        }
        Zip64EndOfCentralDirectoryLocator zip64EndOfCentralDirectoryLocator = zipModel.getZip64EndOfCentralDirectoryLocator();
        zip64EndOfCentralDirectoryLocator.setNumberOfDiskStartOfZip64EndOfCentralDirectoryRecord(0);
        zip64EndOfCentralDirectoryLocator.setOffsetZip64EndOfCentralDirectoryRecord(zip64EndOfCentralDirectoryLocator.getOffsetZip64EndOfCentralDirectoryRecord() + l2);
        zip64EndOfCentralDirectoryLocator.setTotalNumberOfDiscs(1);
    }

    private void updateSplitZip64EndCentralDirRec(ZipModel zipModel, long l2) {
        if (zipModel.getZip64EndOfCentralDirectoryRecord() == null) {
            return;
        }
        Zip64EndOfCentralDirectoryRecord zip64EndOfCentralDirectoryRecord = zipModel.getZip64EndOfCentralDirectoryRecord();
        zip64EndOfCentralDirectoryRecord.setNumberOfThisDisk(0);
        zip64EndOfCentralDirectoryRecord.setNumberOfThisDiskStartOfCentralDirectory(0);
        zip64EndOfCentralDirectoryRecord.setTotalNumberOfEntriesInCentralDirectoryOnThisDisk(zipModel.getEndOfCentralDirectoryRecord().getTotalNumberOfEntriesInCentralDirectory());
        zip64EndOfCentralDirectoryRecord.setOffsetStartCentralDirectoryWRTStartDiskNumber(zip64EndOfCentralDirectoryRecord.getOffsetStartCentralDirectoryWRTStartDiskNumber() + l2);
    }

    @Override
    protected ProgressMonitor.Task getTask() {
        return ProgressMonitor.Task.MERGE_ZIP_FILES;
    }

    public static class MergeSplitZipFileTaskParameters
    extends AbstractZipTaskParameters {
        private File outputZipFile;

        public MergeSplitZipFileTaskParameters(File file, Zip4jConfig zip4jConfig) {
            super(zip4jConfig);
            this.outputZipFile = file;
        }
    }
}

