/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.tasks;

import java.io.File;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.forseth11.easybackup.dependencies.zip4j.exception.ZipException;
import me.forseth11.easybackup.dependencies.zip4j.headers.HeaderUtil;
import me.forseth11.easybackup.dependencies.zip4j.headers.HeaderWriter;
import me.forseth11.easybackup.dependencies.zip4j.io.outputstream.SplitOutputStream;
import me.forseth11.easybackup.dependencies.zip4j.model.FileHeader;
import me.forseth11.easybackup.dependencies.zip4j.model.Zip4jConfig;
import me.forseth11.easybackup.dependencies.zip4j.model.ZipModel;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.RandomAccessFileMode;
import me.forseth11.easybackup.dependencies.zip4j.progress.ProgressMonitor;
import me.forseth11.easybackup.dependencies.zip4j.tasks.AbstractModifyFileTask;
import me.forseth11.easybackup.dependencies.zip4j.tasks.AbstractZipTaskParameters;
import me.forseth11.easybackup.dependencies.zip4j.tasks.AsyncZipTask;
import me.forseth11.easybackup.dependencies.zip4j.util.RawIO;
import me.forseth11.easybackup.dependencies.zip4j.util.Zip4jUtil;

public class RenameFilesTask
extends AbstractModifyFileTask<RenameFilesTaskParameters> {
    private ZipModel zipModel;
    private HeaderWriter headerWriter;
    private RawIO rawIO;

    public RenameFilesTask(ZipModel zipModel, HeaderWriter headerWriter, RawIO rawIO, AsyncZipTask.AsyncTaskParameters asyncTaskParameters) {
        super(asyncTaskParameters);
        this.zipModel = zipModel;
        this.headerWriter = headerWriter;
        this.rawIO = rawIO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeTask(RenameFilesTaskParameters renameFilesTaskParameters, ProgressMonitor progressMonitor) {
        Map<String, String> map = this.filterNonExistingEntriesAndAddSeparatorIfNeeded(renameFilesTaskParameters.fileNamesMap);
        if (map.size() == 0) {
            return;
        }
        File file = this.getTemporaryFile(this.zipModel.getZipFile().getPath());
        boolean bl2 = false;
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(this.zipModel.getZipFile(), RandomAccessFileMode.WRITE.getValue());
             SplitOutputStream splitOutputStream = new SplitOutputStream(file);){
            long l2 = 0L;
            Charset charset = renameFilesTaskParameters.zip4jConfig.getCharset();
            List<FileHeader> list = this.cloneAndSortFileHeadersByOffset(this.zipModel.getCentralDirectory().getFileHeaders());
            for (FileHeader fileHeader : list) {
                Map.Entry<String, String> entry = this.getCorrespondingEntryFromMap(fileHeader, map);
                progressMonitor.setFileName(fileHeader.getFileName());
                long l3 = this.getOffsetOfNextEntry(list, fileHeader, this.zipModel) - splitOutputStream.getFilePointer();
                if (entry == null) {
                    l2 += this.copyFile(randomAccessFile, splitOutputStream, l2, l3, progressMonitor, renameFilesTaskParameters.zip4jConfig.getBufferSize());
                } else {
                    String string = this.getNewFileName(entry.getValue(), entry.getKey(), fileHeader.getFileName());
                    byte[] byArray = HeaderUtil.getBytesFromString(string, charset);
                    int n2 = byArray.length - fileHeader.getFileNameLength();
                    l2 = this.copyEntryAndChangeFileName(byArray, fileHeader, l2, l3, randomAccessFile, splitOutputStream, progressMonitor, renameFilesTaskParameters.zip4jConfig.getBufferSize());
                    this.updateHeadersInZipModel(list, fileHeader, string, byArray, n2);
                }
                this.verifyIfTaskIsCancelled();
            }
            this.headerWriter.finalizeZipFile(this.zipModel, splitOutputStream, charset);
            bl2 = true;
        }
        finally {
            this.cleanupFile(bl2, this.zipModel.getZipFile(), file);
        }
    }

    @Override
    protected long calculateTotalWork(RenameFilesTaskParameters renameFilesTaskParameters) {
        return this.zipModel.getZipFile().length();
    }

    @Override
    protected ProgressMonitor.Task getTask() {
        return ProgressMonitor.Task.RENAME_FILE;
    }

    private long copyEntryAndChangeFileName(byte[] byArray, FileHeader fileHeader, long l2, long l3, RandomAccessFile randomAccessFile, OutputStream outputStream, ProgressMonitor progressMonitor, int n2) {
        long l4 = l2;
        l4 += this.copyFile(randomAccessFile, outputStream, l4, 26L, progressMonitor, n2);
        this.rawIO.writeShortLittleEndian(outputStream, byArray.length);
        l4 += 2L;
        l4 += this.copyFile(randomAccessFile, outputStream, l4, 2L, progressMonitor, n2);
        outputStream.write(byArray);
        long l5 = l3 - ((l4 += (long)fileHeader.getFileNameLength()) - l2);
        l4 += this.copyFile(randomAccessFile, outputStream, l4, l5, progressMonitor, n2);
        return l4;
    }

    private Map.Entry<String, String> getCorrespondingEntryFromMap(FileHeader fileHeader, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!fileHeader.getFileName().startsWith(entry.getKey())) continue;
            return entry;
        }
        return null;
    }

    private void updateHeadersInZipModel(List<FileHeader> list, FileHeader fileHeader, String string, byte[] byArray, int n2) {
        FileHeader fileHeader2 = HeaderUtil.getFileHeader(this.zipModel, fileHeader.getFileName());
        if (fileHeader2 == null) {
            throw new ZipException("could not find any header with name: " + fileHeader.getFileName());
        }
        fileHeader2.setFileName(string);
        fileHeader2.setFileNameLength(byArray.length);
        this.updateOffsetsForAllSubsequentFileHeaders(list, this.zipModel, fileHeader2, n2);
        this.zipModel.getEndOfCentralDirectoryRecord().setOffsetOfStartOfCentralDirectory(this.zipModel.getEndOfCentralDirectoryRecord().getOffsetOfStartOfCentralDirectory() + (long)n2);
        if (this.zipModel.isZip64Format()) {
            this.zipModel.getZip64EndOfCentralDirectoryRecord().setOffsetStartCentralDirectoryWRTStartDiskNumber(this.zipModel.getZip64EndOfCentralDirectoryRecord().getOffsetStartCentralDirectoryWRTStartDiskNumber() + (long)n2);
            this.zipModel.getZip64EndOfCentralDirectoryLocator().setOffsetZip64EndOfCentralDirectoryRecord(this.zipModel.getZip64EndOfCentralDirectoryLocator().getOffsetZip64EndOfCentralDirectoryRecord() + (long)n2);
        }
    }

    private Map<String, String> filterNonExistingEntriesAndAddSeparatorIfNeeded(Map<String, String> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            FileHeader fileHeader;
            if (!Zip4jUtil.isStringNotNullAndNotEmpty(entry.getKey()) || (fileHeader = HeaderUtil.getFileHeader(this.zipModel, entry.getKey())) == null) continue;
            if (fileHeader.isDirectory() && !entry.getValue().endsWith("/")) {
                hashMap.put(entry.getKey(), entry.getValue() + "/");
                continue;
            }
            hashMap.put(entry.getKey(), entry.getValue());
        }
        return hashMap;
    }

    private String getNewFileName(String string, String string2, String string3) {
        if (string3.equals(string2)) {
            return string;
        }
        if (string3.startsWith(string2)) {
            String string4 = string3.substring(string2.length());
            return string + string4;
        }
        throw new ZipException("old file name was neither an exact match nor a partial match");
    }

    public static class RenameFilesTaskParameters
    extends AbstractZipTaskParameters {
        private Map<String, String> fileNamesMap;

        public RenameFilesTaskParameters(Map<String, String> map, Zip4jConfig zip4jConfig) {
            super(zip4jConfig);
            this.fileNamesMap = map;
        }
    }
}

