/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import me.forseth11.easybackup.dependencies.zip4j.exception.ZipException;
import me.forseth11.easybackup.dependencies.zip4j.util.Zip4jUtil;

public class RawIO {
    private byte[] shortBuff = new byte[2];
    private byte[] intBuff = new byte[4];
    private byte[] longBuff = new byte[8];

    public long readLongLittleEndian(RandomAccessFile randomAccessFile) {
        randomAccessFile.readFully(this.longBuff);
        return this.readLongLittleEndian(this.longBuff, 0);
    }

    public long readLongLittleEndian(RandomAccessFile randomAccessFile, int n2) {
        this.resetBytes(this.longBuff);
        randomAccessFile.readFully(this.longBuff, 0, n2);
        return this.readLongLittleEndian(this.longBuff, 0);
    }

    public long readLongLittleEndian(InputStream inputStream) {
        this.readFully(inputStream, this.longBuff, this.longBuff.length);
        return this.readLongLittleEndian(this.longBuff, 0);
    }

    public long readLongLittleEndian(InputStream inputStream, int n2) {
        this.resetBytes(this.longBuff);
        this.readFully(inputStream, this.longBuff, n2);
        return this.readLongLittleEndian(this.longBuff, 0);
    }

    public long readLongLittleEndian(byte[] byArray, int n2) {
        if (byArray.length - n2 < 8) {
            this.resetBytes(this.longBuff);
        }
        System.arraycopy(byArray, n2, this.longBuff, 0, byArray.length < 8 ? byArray.length - n2 : 8);
        long l2 = 0L;
        l2 |= (long)(this.longBuff[7] & 0xFF);
        l2 <<= 8;
        l2 |= (long)(this.longBuff[6] & 0xFF);
        l2 <<= 8;
        l2 |= (long)(this.longBuff[5] & 0xFF);
        l2 <<= 8;
        l2 |= (long)(this.longBuff[4] & 0xFF);
        l2 <<= 8;
        l2 |= (long)(this.longBuff[3] & 0xFF);
        l2 <<= 8;
        l2 |= (long)(this.longBuff[2] & 0xFF);
        l2 <<= 8;
        l2 |= (long)(this.longBuff[1] & 0xFF);
        l2 <<= 8;
        return l2 |= (long)(this.longBuff[0] & 0xFF);
    }

    public int readIntLittleEndian(RandomAccessFile randomAccessFile) {
        randomAccessFile.readFully(this.intBuff);
        return this.readIntLittleEndian(this.intBuff);
    }

    public int readIntLittleEndian(InputStream inputStream) {
        this.readFully(inputStream, this.intBuff, 4);
        return this.readIntLittleEndian(this.intBuff);
    }

    public int readIntLittleEndian(byte[] byArray) {
        return this.readIntLittleEndian(byArray, 0);
    }

    public int readIntLittleEndian(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF | (byArray[1 + n2] & 0xFF) << 8 | (byArray[2 + n2] & 0xFF | (byArray[3 + n2] & 0xFF) << 8) << 16;
    }

    public int readShortLittleEndian(RandomAccessFile randomAccessFile) {
        randomAccessFile.readFully(this.shortBuff);
        return this.readShortLittleEndian(this.shortBuff, 0);
    }

    public int readShortLittleEndian(InputStream inputStream) {
        this.readFully(inputStream, this.shortBuff, this.shortBuff.length);
        return this.readShortLittleEndian(this.shortBuff, 0);
    }

    public int readShortLittleEndian(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF | (byArray[1 + n2] & 0xFF) << 8;
    }

    public void writeShortLittleEndian(OutputStream outputStream, int n2) {
        this.writeShortLittleEndian(this.shortBuff, 0, n2);
        outputStream.write(this.shortBuff);
    }

    public void writeShortLittleEndian(byte[] byArray, int n2, int n3) {
        byArray[n2 + 1] = (byte)(n3 >>> 8);
        byArray[n2] = (byte)(n3 & 0xFF);
    }

    public void writeIntLittleEndian(OutputStream outputStream, int n2) {
        this.writeIntLittleEndian(this.intBuff, 0, n2);
        outputStream.write(this.intBuff);
    }

    public void writeIntLittleEndian(byte[] byArray, int n2, int n3) {
        byArray[n2 + 3] = (byte)(n3 >>> 24);
        byArray[n2 + 2] = (byte)(n3 >>> 16);
        byArray[n2 + 1] = (byte)(n3 >>> 8);
        byArray[n2] = (byte)(n3 & 0xFF);
    }

    public void writeLongLittleEndian(OutputStream outputStream, long l2) {
        this.writeLongLittleEndian(this.longBuff, 0, l2);
        outputStream.write(this.longBuff);
    }

    public void writeLongLittleEndian(byte[] byArray, int n2, long l2) {
        byArray[n2 + 7] = (byte)(l2 >>> 56);
        byArray[n2 + 6] = (byte)(l2 >>> 48);
        byArray[n2 + 5] = (byte)(l2 >>> 40);
        byArray[n2 + 4] = (byte)(l2 >>> 32);
        byArray[n2 + 3] = (byte)(l2 >>> 24);
        byArray[n2 + 2] = (byte)(l2 >>> 16);
        byArray[n2 + 1] = (byte)(l2 >>> 8);
        byArray[n2] = (byte)(l2 & 0xFFL);
    }

    private void readFully(InputStream inputStream, byte[] byArray, int n2) {
        int n3 = Zip4jUtil.readFully(inputStream, byArray, 0, n2);
        if (n3 != n2) {
            throw new ZipException("Could not fill buffer");
        }
    }

    private void resetBytes(byte[] byArray) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = 0;
        }
    }
}

