/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.util;

import me.forseth11.easybackup.dependencies.zip4j.headers.VersionMadeBy;
import me.forseth11.easybackup.dependencies.zip4j.headers.VersionNeededToExtract;
import me.forseth11.easybackup.dependencies.zip4j.model.ZipParameters;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.CompressionMethod;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.EncryptionMethod;
import me.forseth11.easybackup.dependencies.zip4j.util.FileUtils;
import me.forseth11.easybackup.dependencies.zip4j.util.RawIO;

public class ZipVersionUtils {
    public static int determineVersionMadeBy(ZipParameters zipParameters, RawIO rawIO) {
        byte[] byArray = new byte[]{VersionMadeBy.SPECIFICATION_VERSION.getCode(), VersionMadeBy.UNIX.getCode()};
        if (FileUtils.isWindows() && !zipParameters.isUnixMode()) {
            byArray[1] = VersionMadeBy.WINDOWS.getCode();
        }
        return rawIO.readShortLittleEndian(byArray, 0);
    }

    public static VersionNeededToExtract determineVersionNeededToExtract(ZipParameters zipParameters) {
        VersionNeededToExtract versionNeededToExtract = VersionNeededToExtract.DEFAULT;
        if (zipParameters.getCompressionMethod() == CompressionMethod.DEFLATE) {
            versionNeededToExtract = VersionNeededToExtract.DEFLATE_COMPRESSED;
        }
        if (zipParameters.getEntrySize() > 0xFFFFFFFFL) {
            versionNeededToExtract = VersionNeededToExtract.ZIP_64_FORMAT;
        }
        if (zipParameters.isEncryptFiles() && zipParameters.getEncryptionMethod().equals((Object)EncryptionMethod.AES)) {
            versionNeededToExtract = VersionNeededToExtract.AES_ENCRYPTED;
        }
        return versionNeededToExtract;
    }
}

