/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core;

import com.willfp.eco.core.AbstractPacketAdapter;
import com.willfp.eco.core.Eco;
import com.willfp.eco.core.LifecyclePosition;
import com.willfp.eco.core.PluginLike;
import com.willfp.eco.core.PluginProps;
import com.willfp.eco.core.Prerequisite;
import com.willfp.eco.core.command.impl.PluginCommand;
import com.willfp.eco.core.config.base.ConfigYml;
import com.willfp.eco.core.config.base.LangYml;
import com.willfp.eco.core.config.updating.ConfigHandler;
import com.willfp.eco.core.display.Display;
import com.willfp.eco.core.display.DisplayModule;
import com.willfp.eco.core.events.EventManager;
import com.willfp.eco.core.extensions.Extension;
import com.willfp.eco.core.extensions.ExtensionLoader;
import com.willfp.eco.core.factory.MetadataValueFactory;
import com.willfp.eco.core.factory.NamespacedKeyFactory;
import com.willfp.eco.core.factory.RunnableFactory;
import com.willfp.eco.core.integrations.IntegrationLoader;
import com.willfp.eco.core.map.ListMap;
import com.willfp.eco.core.packet.PacketListener;
import com.willfp.eco.core.proxy.ProxyFactory;
import com.willfp.eco.core.registry.Registrable;
import com.willfp.eco.core.registry.Registry;
import com.willfp.eco.core.scheduling.Scheduler;
import com.willfp.eco.core.version.OutdatedEcoVersionError;
import com.willfp.eco.core.version.Version;
import com.willfp.eco.core.web.UpdateChecker;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class EcoPlugin
extends JavaPlugin
implements PluginLike,
Registrable {
    private final PluginProps props;
    private final Set<String> loadedIntegrations = new HashSet<String>();
    private final Scheduler scheduler;
    private final EventManager eventManager;
    private final ConfigYml configYml;
    private final LangYml langYml;
    private final NamespacedKeyFactory namespacedKeyFactory;
    private final MetadataValueFactory metadataValueFactory;
    private final RunnableFactory runnableFactory;
    private final ExtensionLoader extensionLoader;
    private final ConfigHandler configHandler;
    private DisplayModule displayModule;
    private Logger logger;
    private boolean outdated = false;
    @Nullable
    private final ProxyFactory proxyFactory;
    private final ListMap<LifecyclePosition, Runnable> onEnable = new ListMap();
    private final ListMap<LifecyclePosition, Runnable> onDisable = new ListMap();
    private final ListMap<LifecyclePosition, Runnable> onReload = new ListMap();
    private final ListMap<LifecyclePosition, Runnable> onLoad = new ListMap();
    private final ListMap<LifecyclePosition, Runnable> afterLoad = new ListMap();
    private final ListMap<LifecyclePosition, Runnable> onCreateTasks = new ListMap();

    protected EcoPlugin() {
        this((PluginProps)null);
    }

    @Deprecated(since="6.53.0", forRemoval=true)
    protected EcoPlugin(@NotNull String color) {
        this("", color);
    }

    @Deprecated(since="6.53.0", forRemoval=true)
    protected EcoPlugin(@NotNull String proxyPackage, @NotNull String color) {
        this(0, 0, proxyPackage, color);
    }

    @Deprecated(since="6.53.0", forRemoval=true)
    protected EcoPlugin(int resourceId, int bStatsId, @NotNull String color) {
        this(resourceId, bStatsId, "", color);
    }

    @Deprecated(since="6.53.0", forRemoval=true)
    protected EcoPlugin(int resourceId, int bStatsId, @NotNull String color, boolean supportingExtensions) {
        this(resourceId, bStatsId, "", color, supportingExtensions);
    }

    @Deprecated(since="6.53.0", forRemoval=true)
    protected EcoPlugin(int resourceId, int bStatsId, @NotNull String proxyPackage, @NotNull String color) {
        this(resourceId, bStatsId, proxyPackage, color, false);
    }

    @Deprecated(since="6.53.0", forRemoval=true)
    protected EcoPlugin(int resourceId, int bStatsId, @NotNull String proxyPackage, @NotNull String color, boolean supportingExtensions) {
        this(PluginProps.createSimple(resourceId, bStatsId, proxyPackage, color, supportingExtensions));
    }

    protected EcoPlugin(@Nullable PluginProps pluginProps) {
        if (Eco.get() == null && this instanceof Eco) {
            Eco.Instance.set((Eco)((Object)this));
        }
        assert (Eco.get() != null);
        PluginProps generatedProps = Eco.get().getProps(pluginProps, this.getClass());
        generatedProps.validate();
        PluginProps props = this.mutateProps(generatedProps);
        props.validate();
        this.props = props;
        this.proxyFactory = this.props.getProxyPackage().equalsIgnoreCase("") ? null : Eco.get().createProxyFactory(this);
        this.logger = Eco.get().createLogger(this);
        this.getLogger().info("Initializing " + this.getColor() + this.getName());
        this.scheduler = Eco.get().createScheduler(this);
        this.eventManager = Eco.get().createEventManager(this);
        this.namespacedKeyFactory = Eco.get().createNamespacedKeyFactory(this);
        this.metadataValueFactory = Eco.get().createMetadataValueFactory(this);
        this.runnableFactory = Eco.get().createRunnableFactory(this);
        this.extensionLoader = Eco.get().createExtensionLoader(this);
        this.configHandler = Eco.get().createConfigHandler(this);
        this.langYml = this.createLangYml();
        if (!this.langYml.isValid() && !(this instanceof Eco)) {
            this.getLogger().warning("Notify plugin authors " + String.join((CharSequence)", ", this.getDescription().getAuthors()) + " that");
            this.getLogger().warning("they are missing crucial lang.yml keys! They can be found");
            this.getLogger().warning("in the LangYml class.");
        }
        this.configYml = this.createConfigYml();
        Eco.get().addNewPlugin(this);
        Version runningVersion = new Version(Eco.get().getEcoPlugin().getDescription().getVersion());
        Version requiredVersion = new Version(this.getMinimumEcoVersion());
        if (runningVersion.compareTo(requiredVersion) <= 0 && !runningVersion.equals(requiredVersion)) {
            this.getLogger().severe("You are running an outdated version of eco!");
            this.getLogger().severe("You must be on at least" + this.getMinimumEcoVersion());
            this.getLogger().severe("Download the newest version here:");
            this.getLogger().severe("https://polymart.org/download/773/recent/JSpprMspkuyecf5y1wQ2Jn8OoLQSQ_IW");
            throw new OutdatedEcoVersionError("This plugin requires at least eco version " + this.getMinimumEcoVersion() + " to run.");
        }
    }

    public final void onEnable() {
        Set enabledPlugins;
        super.onEnable();
        this.getLogger().info("Loading " + this.getColor() + this.getName());
        if (this.getResourceId() != 0 && !Eco.get().getEcoPlugin().getConfigYml().getBool("no-update-checker")) {
            new UpdateChecker(this).getVersion(version2 -> {
                Version mostRecentVersion;
                Version currentVersion = new Version(this.getDescription().getVersion());
                if (currentVersion.compareTo(mostRecentVersion = new Version((String)version2)) <= 0 && !currentVersion.equals(mostRecentVersion)) {
                    this.outdated = true;
                    this.getLogger().warning(this.getName() + " is out of date! (Version " + this.getDescription().getVersion() + ")");
                    this.getLogger().warning("The newest version is " + version2);
                    this.getLogger().warning("Download the new version!");
                }
            });
        }
        if (this.getBStatsId() != 0) {
            Eco.get().registerBStats(this);
        }
        if ((enabledPlugins = Arrays.stream(Bukkit.getPluginManager().getPlugins()).map(Plugin::getName).map(String::toLowerCase).collect(Collectors.toSet())).contains("PlaceholderAPI".toLowerCase())) {
            Eco.get().createPAPIIntegration(this);
        }
        this.loadIntegrationLoaders().forEach(integrationLoader -> {
            if (enabledPlugins.contains(integrationLoader.getPluginName().toLowerCase())) {
                try {
                    integrationLoader.load();
                    this.loadedIntegrations.add(integrationLoader.getPluginName());
                }
                catch (Exception e) {
                    this.getLogger().warning("Failed to load integration for " + integrationLoader.getPluginName());
                    e.printStackTrace();
                }
            }
        });
        this.loadedIntegrations.removeIf(pl -> pl.equalsIgnoreCase(this.getName()));
        if (!this.getLoadedIntegrations().isEmpty()) {
            this.getLogger().info("Loaded integrations: " + String.join((CharSequence)", ", this.getLoadedIntegrations()));
        }
        Prerequisite.update();
        if (Prerequisite.HAS_PROTOCOLLIB.isMet()) {
            this.loadPacketAdapters().forEach(abstractPacketAdapter -> {
                if (!abstractPacketAdapter.isPostLoad()) {
                    abstractPacketAdapter.register();
                }
            });
        }
        this.loadListeners().forEach(listener -> this.getEventManager().registerListener((Listener)listener));
        this.loadPacketListeners().forEach(listener -> this.getEventManager().registerPacketListener((PacketListener)listener));
        this.loadPluginCommands().forEach(PluginCommand::register);
        this.getScheduler().runLater(() -> {
            Logger before = this.getLogger();
            this.logger = Eco.get().getNOOPLogger();
            this.reload(false);
            this.logger = before;
        }, 1L);
        this.getScheduler().runLater(this::afterLoad, 2L);
        if (this.isSupportingExtensions()) {
            this.getExtensionLoader().loadExtensions();
            if (!this.getExtensionLoader().getLoadedExtensions().isEmpty()) {
                List<String> loadedExtensions = this.getExtensionLoader().getLoadedExtensions().stream().map(extension -> extension.getName() + " v" + extension.getVersion()).toList();
                this.getLogger().info("Loaded extensions: " + String.join((CharSequence)", ", loadedExtensions));
            }
        }
        this.handleLifecycle(this.onEnable, this::handleEnable);
    }

    public final void onEnable(@NotNull Runnable task) {
        this.onEnable(LifecyclePosition.END, task);
    }

    public final void onEnable(@NotNull LifecyclePosition position, @NotNull Runnable task) {
        this.onEnable.append(position, task);
    }

    public final void onDisable() {
        super.onDisable();
        this.getEventManager().unregisterAllListeners();
        this.getScheduler().cancelAll();
        this.handleLifecycle(this.onDisable, this::handleDisable);
        if (this.isSupportingExtensions()) {
            this.getExtensionLoader().unloadExtensions();
        }
        this.getLogger().info("Cleaning up...");
        Eco.get().clean(this);
    }

    public final void onDisable(@NotNull Runnable task) {
        this.onDisable(LifecyclePosition.END, task);
    }

    public final void onDisable(@NotNull LifecyclePosition position, @NotNull Runnable task) {
        this.onDisable.append(position, task);
    }

    public final void onLoad() {
        super.onLoad();
        this.handleLifecycle(this.onLoad, this::handleLoad);
    }

    public final void onLoad(@NotNull Runnable task) {
        this.onLoad(LifecyclePosition.END, task);
    }

    public final void onLoad(@NotNull LifecyclePosition position, @NotNull Runnable task) {
        this.onLoad.append(position, task);
    }

    public final void afterLoad() {
        this.displayModule = this.createDisplayModule();
        if (this.getDisplayModule() != null) {
            Display.registerDisplayModule(this.getDisplayModule());
        }
        if (Prerequisite.HAS_PROTOCOLLIB.isMet()) {
            this.loadPacketAdapters().forEach(abstractPacketAdapter -> {
                if (abstractPacketAdapter.isPostLoad()) {
                    abstractPacketAdapter.register();
                }
            });
        }
        if (!Prerequisite.HAS_PAPER.isMet()) {
            this.getLogger().severe("");
            this.getLogger().severe("----------------------------");
            this.getLogger().severe("");
            this.getLogger().severe("You don't seem to be running paper!");
            this.getLogger().severe("Paper is strongly recommended for all servers,");
            this.getLogger().severe("and some things may not function properly without it");
            this.getLogger().severe("Download Paper from &fhttps://papermc.io");
            this.getLogger().severe("");
            this.getLogger().severe("----------------------------");
            this.getLogger().severe("");
        }
        this.handleLifecycle(this.afterLoad, this::handleAfterLoad);
        this.reload();
        for (Extension extension : this.getExtensionLoader().getLoadedExtensions()) {
            extension.handleAfterLoad();
        }
        this.getLogger().info("Loaded " + this.props.getColor() + this.getName());
    }

    public final void afterLoad(@NotNull Runnable task) {
        this.afterLoad(LifecyclePosition.END, task);
    }

    public final void afterLoad(@NotNull LifecyclePosition position, @NotNull Runnable task) {
        this.afterLoad.append(position, task);
    }

    public final void reload() {
        this.reload(true);
    }

    public final void reload(boolean cancelTasks) {
        this.getConfigHandler().updateConfigs();
        if (cancelTasks) {
            this.getScheduler().cancelAll();
        }
        this.getConfigHandler().callUpdate();
        this.getConfigHandler().callUpdate();
        this.handleLifecycle(this.onReload, this::handleReload);
        if (cancelTasks) {
            this.handleLifecycle(this.onCreateTasks, this::createTasks);
        }
        for (Extension extension : this.extensionLoader.getLoadedExtensions()) {
            extension.handleReload();
        }
    }

    public final void onReload(@NotNull Runnable task) {
        this.onReload(LifecyclePosition.END, task);
    }

    public final void onReload(@NotNull LifecyclePosition position, @NotNull Runnable task) {
        this.onReload.append(position, task);
    }

    public final void onCreateTasks(@NotNull Runnable task) {
        this.onCreateTasks(LifecyclePosition.END, task);
    }

    public final void onCreateTasks(@NotNull LifecyclePosition position, @NotNull Runnable task) {
        this.onCreateTasks.append(position, task);
    }

    public final long reloadWithTime() {
        long startTime = System.currentTimeMillis();
        this.reload();
        return System.currentTimeMillis() - startTime;
    }

    private void handleLifecycle(@NotNull ListMap<LifecyclePosition, Runnable> tasks, @NotNull Runnable handler) {
        for (Runnable task : (List)tasks.get((Object)LifecyclePosition.START)) {
            try {
                task.run();
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Error while running lifecycle task!");
                this.getLogger().log(Level.SEVERE, "The plugin may not function properly");
                e.printStackTrace();
            }
        }
        try {
            handler.run();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Error while running lifecycle task!");
            this.getLogger().log(Level.SEVERE, "The plugin may not function properly");
            e.printStackTrace();
        }
        for (Runnable task : (List)tasks.get((Object)LifecyclePosition.END)) {
            try {
                task.run();
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Error while running lifecycle task!");
                this.getLogger().log(Level.SEVERE, "The plugin may not function properly");
                e.printStackTrace();
            }
        }
    }

    protected void handleEnable() {
    }

    protected void handleDisable() {
    }

    protected void handleLoad() {
    }

    protected void handleReload() {
    }

    protected void createTasks() {
    }

    protected void handleAfterLoad() {
    }

    protected PluginProps mutateProps(@NotNull PluginProps props) {
        return props;
    }

    protected List<IntegrationLoader> loadIntegrationLoaders() {
        return new ArrayList<IntegrationLoader>();
    }

    protected List<PluginCommand> loadPluginCommands() {
        return new ArrayList<PluginCommand>();
    }

    @Deprecated(since="6.51.0")
    protected List<AbstractPacketAdapter> loadPacketAdapters() {
        return new ArrayList<AbstractPacketAdapter>();
    }

    protected List<PacketListener> loadPacketListeners() {
        return new ArrayList<PacketListener>();
    }

    protected List<Listener> loadListeners() {
        return new ArrayList<Listener>();
    }

    protected LangYml createLangYml() {
        try {
            return new LangYml(this);
        }
        catch (NullPointerException e) {
            this.getLogger().severe("Failed to load lang.yml!");
            this.getLogger().severe("For the developer of this plugin: make sure you have a lang.yml");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return null;
        }
    }

    protected ConfigYml createConfigYml() {
        try {
            return new ConfigYml(this);
        }
        catch (NullPointerException e) {
            this.getLogger().severe("Failed to load config.yml!");
            this.getLogger().severe("For the developer of this plugin: make sure you have a config.yml");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return null;
        }
    }

    @Nullable
    protected DisplayModule createDisplayModule() {
        Validate.isTrue((this.getDisplayModule() == null ? 1 : 0) != 0, (String)"Display module exists!");
        return null;
    }

    public String getMinimumEcoVersion() {
        return "6.0.0";
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    public final <T> T getProxy(@NotNull Class<T> proxyClass) {
        Validate.notNull((Object)this.proxyFactory, (String)"Plugin does not support proxies!");
        return this.proxyFactory.getProxy(proxyClass);
    }

    @Deprecated
    @NotNull
    public final FileConfiguration getConfig() {
        this.getLogger().warning("Call to default config method in eco plugin!");
        return (FileConfiguration)Objects.requireNonNull(this.getConfigYml().toBukkit());
    }

    @Deprecated
    public final void saveConfig() {
        this.getLogger().warning("Call to default config method in eco plugin!");
        super.saveConfig();
    }

    @Deprecated
    public final void saveDefaultConfig() {
        this.getLogger().warning("Call to default config method in eco plugin!");
        super.saveDefaultConfig();
    }

    @Deprecated
    public final void reloadConfig() {
        this.getLogger().warning("Call to default config method in eco plugin!");
        super.reloadConfig();
    }

    @Nullable
    public static EcoPlugin getPlugin(@NotNull String pluginName) {
        return Eco.get().getPluginByName(pluginName);
    }

    @NotNull
    public static Set<String> getPluginNames() {
        return new HashSet<String>(Eco.get().getLoadedPlugins());
    }

    @NotNull
    public PluginProps getProps() {
        return this.props;
    }

    public int getResourceId() {
        return this.getProps().getResourceId();
    }

    public int getBStatsId() {
        return this.getProps().getBStatsId();
    }

    public String getProxyPackage() {
        return this.getProps().getProxyPackage();
    }

    public String getColor() {
        return this.getProps().getColor();
    }

    public Set<String> getLoadedIntegrations() {
        return this.loadedIntegrations;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public ConfigYml getConfigYml() {
        return this.configYml;
    }

    public LangYml getLangYml() {
        return this.langYml;
    }

    public NamespacedKeyFactory getNamespacedKeyFactory() {
        return this.namespacedKeyFactory;
    }

    public MetadataValueFactory getMetadataValueFactory() {
        return this.metadataValueFactory;
    }

    public RunnableFactory getRunnableFactory() {
        return this.runnableFactory;
    }

    public ExtensionLoader getExtensionLoader() {
        return this.extensionLoader;
    }

    @Override
    @NotNull
    public ConfigHandler getConfigHandler() {
        return this.configHandler;
    }

    @Nullable
    public DisplayModule getDisplayModule() {
        return this.displayModule;
    }

    public boolean isOutdated() {
        return this.outdated;
    }

    public boolean isSupportingExtensions() {
        return this.getProps().isSupportingExtensions();
    }

    @Nullable
    public ProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    @NotNull
    public NamespacedKey createNamespacedKey(@NotNull String key) {
        return this.getNamespacedKeyFactory().create(key);
    }

    @NotNull
    public FixedMetadataValue createMetadataValue(@NotNull Object value) {
        return this.getMetadataValueFactory().create(value);
    }

    public boolean isUsingLocalStorage() {
        return this.configYml.isUsingLocalStorage();
    }

    @Override
    @NotNull
    public final String getID() {
        return Registry.tryFitPattern(this.getName());
    }

    @Override
    @NotNull
    public File getFile() {
        return super.getFile();
    }
}

