/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.data;

import com.willfp.eco.core.data.ExternalDataStoreObjectAdapter;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public final class ExternalDataStore {
    private static final Map<String, Object> DATA = new HashMap<String, Object>();
    private static final List<ExternalDataStoreObjectAdapter<?, ?>> STORE_ADAPTERS = new ArrayList();

    public static void put(@NotNull String key, @NotNull Object value) {
        ExternalDataStore.doPut(key, value);
    }

    private static <A> void doPut(@NotNull String key, @NotNull A value) {
        Object storedValue = value;
        for (ExternalDataStoreObjectAdapter<?, ?> unknownAdapter : STORE_ADAPTERS) {
            if (!unknownAdapter.getAccessedClass().isInstance(value)) continue;
            ExternalDataStoreObjectAdapter<?, ?> adapter = unknownAdapter;
            storedValue = adapter.toStoredObject(value);
            break;
        }
        DATA.put(key, storedValue);
    }

    @Nullable
    public static <T> T get(@NotNull String key, @NotNull Class<T> clazz) {
        return ExternalDataStore.doGet(key, clazz);
    }

    @Nullable
    private static <A, S> A doGet(@NotNull String key, @NotNull Class<A> clazz) {
        Object value = DATA.get(key);
        for (ExternalDataStoreObjectAdapter<?, ?> unknownAdapter : STORE_ADAPTERS) {
            if (!unknownAdapter.getStoredClass().isInstance(value) || !unknownAdapter.getAccessedClass().equals(clazz)) continue;
            ExternalDataStoreObjectAdapter<?, ?> adapter = unknownAdapter;
            value = adapter.toAccessedObject(value);
            break;
        }
        if (clazz.isInstance(value)) {
            return clazz.cast(value);
        }
        return null;
    }

    @NotNull
    public static <T> T get(@NotNull String key, @NotNull Class<T> clazz, @NotNull T defaultValue) {
        T value = ExternalDataStore.get(key, clazz);
        return value == null ? defaultValue : value;
    }

    @NotNull
    public static <T> T get(@NotNull String key, @NotNull Class<T> clazz, @NotNull Supplier<T> defaultValue) {
        return ExternalDataStore.get(key, clazz, defaultValue.get());
    }

    public static void registerAdapter(@NotNull ExternalDataStoreObjectAdapter<?, ?> adapter) {
        STORE_ADAPTERS.add(adapter);
    }

    private ExternalDataStore() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

