/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.entities;

import com.willfp.eco.core.entities.Entities;
import com.willfp.eco.core.entities.TestableEntity;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;

public class CustomEntity
implements TestableEntity {
    private final NamespacedKey key;
    private final Predicate<@NotNull Entity> test;
    private final Function<Location, Entity> provider;

    public CustomEntity(@NotNull NamespacedKey key, @NotNull @NotNull Predicate<@NotNull Entity> test, @NotNull Function<Location, Entity> provider) {
        this.key = key;
        this.test = test;
        this.provider = provider;
    }

    @Override
    public boolean matches(@Nullable Entity entity) {
        if (entity == null) {
            return false;
        }
        return this.test.test(entity);
    }

    @Override
    public Entity spawn(@NotNull Location location) {
        Validate.notNull((Object)location.getWorld());
        return this.provider.apply(location);
    }

    public void register() {
        Entities.registerCustomEntity(this.getKey(), this);
    }

    public NamespacedKey getKey() {
        return this.key;
    }
}

