/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.entities.ai;

import com.google.common.collect.HashBiMap;
import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.core.entities.ai.TargetGoal;
import com.willfp.eco.core.entities.ai.target.TargetGoalDefendVillage;
import com.willfp.eco.core.entities.ai.target.TargetGoalHurtBy;
import com.willfp.eco.core.entities.ai.target.TargetGoalNearestAttackable;
import com.willfp.eco.core.entities.ai.target.TargetGoalNearestAttackableWitch;
import com.willfp.eco.core.entities.ai.target.TargetGoalNearestHealableRaider;
import com.willfp.eco.core.entities.ai.target.TargetGoalNonTameRandom;
import com.willfp.eco.core.entities.ai.target.TargetGoalOwnerHurtBy;
import com.willfp.eco.core.entities.ai.target.TargetGoalOwnerTarget;
import com.willfp.eco.core.entities.ai.target.TargetGoalResetUniversalAnger;
import com.willfp.eco.core.serialization.KeyedDeserializer;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.Map;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Mob;

public final class TargetGoals {
    private static final Map<NamespacedKey, KeyedDeserializer<? extends TargetGoal<?>>> BY_KEY = HashBiMap.create();

    @Nullable
    public static KeyedDeserializer<? extends TargetGoal<? extends Mob>> getByKey(@NotNull NamespacedKey key) {
        return BY_KEY.get(key);
    }

    @Nullable
    public static <T extends Mob> KeyedDeserializer<TargetGoal<T>> getByKeyOfType(@NotNull NamespacedKey key, @NotNull Class<T> clazz) {
        return BY_KEY.get(key);
    }

    @NotNull
    public static <T extends Mob> T applyToEntity(@NotNull T entity, @NotNull NamespacedKey key, @NotNull Config config, int priority) {
        KeyedDeserializer<TargetGoal<?>> deserializer = TargetGoals.getByKeyOfType(key, entity.getClass());
        if (deserializer == null) {
            return entity;
        }
        TargetGoal goal = (TargetGoal)deserializer.deserialize(config);
        if (goal == null) {
            return entity;
        }
        return goal.addToEntity(entity, priority);
    }

    @NotNull
    public static <T extends KeyedDeserializer<? extends TargetGoal<?>>> T register(@NotNull T toRegister) {
        BY_KEY.put(toRegister.getKey(), toRegister);
        return toRegister;
    }

    private TargetGoals() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        TargetGoals.register(TargetGoalDefendVillage.DESERIALIZER);
        TargetGoals.register(TargetGoalHurtBy.DESERIALIZER);
        TargetGoals.register(TargetGoalNearestAttackable.DESERIALIZER);
        TargetGoals.register(TargetGoalNearestAttackableWitch.DESERIALIZER);
        TargetGoals.register(TargetGoalNearestHealableRaider.DESERIALIZER);
        TargetGoals.register(TargetGoalNonTameRandom.DESERIALIZER);
        TargetGoals.register(TargetGoalOwnerTarget.DESERIALIZER);
        TargetGoals.register(TargetGoalOwnerHurtBy.DESERIALIZER);
        TargetGoals.register(TargetGoalResetUniversalAnger.DESERIALIZER);
    }
}

