/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.entities.ai.target;

import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.core.entities.Entities;
import com.willfp.eco.core.entities.TestableEntity;
import com.willfp.eco.core.entities.ai.TargetGoal;
import com.willfp.eco.core.serialization.KeyedDeserializer;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.function.Predicate;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Raider;

public record TargetGoalNearestAttackable(@NotNull TestableEntity target, boolean checkVisibility, boolean checkCanNavigate, int reciprocalChance, @NotNull Predicate<LivingEntity> targetFilter) implements TargetGoal<Raider>
{
    public static final KeyedDeserializer<TargetGoalNearestAttackable> DESERIALIZER = new Deserializer();

    public TargetGoalNearestAttackable(@NotNull TestableEntity target, boolean checkVisibility, boolean checkCanNavigate, int reciprocalChance) {
        this(target, checkVisibility, checkCanNavigate, reciprocalChance, it -> true);
    }

    private static final class Deserializer
    implements KeyedDeserializer<TargetGoalNearestAttackable> {
        private Deserializer() {
        }

        @Override
        @Nullable
        public TargetGoalNearestAttackable deserialize(@NotNull Config config) {
            if (!(config.has("target") && config.has("checkVisibility") && config.has("checkCanNavigate") && config.has("reciprocalChance"))) {
                return null;
            }
            if (config.has("targetFilter")) {
                TestableEntity filter2 = Entities.lookup(config.getString("targetFilter"));
                return new TargetGoalNearestAttackable(Entities.lookup(config.getString("target")), config.getBool("checkVisibility"), config.getBool("checkCanNavigate"), config.getInt("reciprocalChance"), filter2::matches);
            }
            return new TargetGoalNearestAttackable(Entities.lookup(config.getString("target")), config.getBool("checkVisibility"), config.getBool("checkCanNavigate"), config.getInt("reciprocalChance"));
        }

        @NotNull
        public NamespacedKey getKey() {
            return NamespacedKey.minecraft((String)"nearest_attackable");
        }
    }
}

