/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.entities.impl;

import com.willfp.eco.core.entities.TestableEntity;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class SimpleTestableEntity
implements TestableEntity {
    private final EntityType type;

    public SimpleTestableEntity(@NotNull EntityType type2) {
        this.type = type2;
        Validate.notNull((Object)type2.getEntityClass(), (String)"Entity cannot be of unknown type!");
    }

    @Override
    public boolean matches(@Nullable Entity entity) {
        return entity != null && entity.getType() == this.type;
    }

    @Override
    public Entity spawn(@NotNull Location location) {
        Validate.notNull((Object)location.getWorld());
        assert (this.type.getEntityClass() != null);
        return location.getWorld().spawn(location, this.type.getEntityClass());
    }

    public EntityType getType() {
        return this.type;
    }
}

