/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.gui.menu;

import com.willfp.eco.core.gui.GUIComponent;
import com.willfp.eco.core.gui.menu.CloseHandler;
import com.willfp.eco.core.gui.menu.Menu;
import com.willfp.eco.core.gui.menu.MenuEventHandler;
import com.willfp.eco.core.gui.menu.MenuLayer;
import com.willfp.eco.core.gui.menu.OpenHandler;
import com.willfp.eco.core.gui.page.Page;
import com.willfp.eco.core.gui.page.PageBuilder;
import com.willfp.eco.core.gui.slot.FillerMask;
import com.willfp.eco.core.gui.slot.Slot;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryCloseEvent;

public interface MenuBuilder
extends PageBuilder {
    public MenuBuilder setTitle(@NotNull String var1);

    default public String getTitle() {
        return "";
    }

    @Override
    default public MenuBuilder setSlot(int row2, int column, @NotNull Slot slot) {
        return this.addComponent(row2, column, slot);
    }

    @Override
    public MenuBuilder addComponent(@NotNull MenuLayer var1, int var2, int var3, @NotNull GUIComponent var4);

    @Override
    default public MenuBuilder addComponent(int row2, int column, @NotNull GUIComponent component) {
        return this.addComponent(MenuLayer.MIDDLE, row2, column, component);
    }

    public MenuBuilder modfiy(@NotNull Consumer<MenuBuilder> var1);

    @Override
    default public MenuBuilder setMask(@NotNull FillerMask mask) {
        return this.addComponent(MenuLayer.BACKGROUND, 1, 1, mask);
    }

    default public MenuBuilder addPage(@NotNull Page page) {
        return this.addComponent(MenuLayer.UPPER, 1, 1, page);
    }

    default public MenuBuilder addPage(int pageNumber, @NotNull PageBuilder builder) {
        return this.addPage(new Page(pageNumber, ((MenuBuilder)builder).build()));
    }

    default public MenuBuilder maxPages(int pages) {
        return this.maxPages(player -> pages);
    }

    default public MenuBuilder maxPages(@NotNull Function<Player, Integer> pages) {
        return this.onRender((player, menu) -> menu.setState((Player)player, "max_page", pages.apply((Player)player)));
    }

    default public MenuBuilder defaultPage(int page) {
        return this.maxPages(player -> page);
    }

    default public MenuBuilder defaultPage(@NotNull Function<Player, Integer> page) {
        return this.onOpen((player, menu) -> menu.setState(player, "page", page.apply(player)));
    }

    default public MenuBuilder onClose(@NotNull Consumer<InventoryCloseEvent> action) {
        return this.onClose((InventoryCloseEvent event, Menu menu) -> action.accept(event));
    }

    public MenuBuilder onClose(@NotNull CloseHandler var1);

    public MenuBuilder onOpen(@NotNull OpenHandler var1);

    @Override
    public MenuBuilder onRender(@NotNull BiConsumer<Player, Menu> var1);

    default public MenuBuilder onEvent(@NotNull MenuEventHandler<?> action) {
        return this;
    }

    default public MenuBuilder allowChangingHeldItem() {
        return this;
    }

    default public MenuBuilder onBuild(@NotNull Consumer<Menu> action) {
        return this;
    }

    public Menu build();
}

