/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.integrations;

import com.willfp.eco.core.Eco;
import com.willfp.eco.core.integrations.Integration;
import com.willfp.eco.core.registry.Registry;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.HashSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class IntegrationRegistry<T extends Integration>
extends Registry<T> {
    @Override
    @NotNull
    public T register(@NotNull T element) {
        return (T)this.executeSafely(() -> super.register(element), element);
    }

    public void forEachSafely(@NotNull Consumer<T> action) {
        for (Integration integration : new HashSet(this.values())) {
            this.executeSafely(() -> action.accept(integration), integration);
        }
    }

    public boolean anySafely(@NotNull Predicate<T> predicate2) {
        for (Integration integration : new HashSet(this.values())) {
            Boolean result2 = this.executeSafely(() -> predicate2.test(integration), integration);
            if (result2 == null || !result2.booleanValue()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public <R> R firstSafely(@NotNull Function<T, R> function, @NotNull R defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        Integration integration = (Integration)this.iterator().next();
        return (R)this.executeSafely(() -> function.apply(integration), integration, defaultValue);
    }

    private void executeSafely(@NotNull Runnable action, @NotNull T integration) {
        this.executeSafely(() -> {
            action.run();
            return null;
        }, integration);
    }

    private <R> R executeSafely(@NotNull Supplier<R> action, @NotNull T integration) {
        return this.executeSafely(action, integration, null);
    }

    private <R> R executeSafely(@NotNull Supplier<R> action, @NotNull T integration, @Nullable R defaultValue) {
        try {
            return action.get();
        }
        catch (Exception | LinkageError e) {
            Eco.get().getEcoPlugin().getLogger().warning("Integration for " + integration.getPluginName() + " threw an exception!");
            Eco.get().getEcoPlugin().getLogger().warning("The integration will be disabled.");
            e.printStackTrace();
            this.remove(integration);
            return defaultValue;
        }
    }

    public boolean allSafely(@NotNull Predicate<T> predicate2) {
        return !this.anySafely(predicate2.negate());
    }
}

