/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.integrations.antigrief;

import com.willfp.eco.core.integrations.IntegrationRegistry;
import com.willfp.eco.core.integrations.antigrief.AntigriefIntegration;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public final class AntigriefManager {
    private static final IntegrationRegistry<AntigriefIntegration> REGISTRY = new IntegrationRegistry();

    public static void register(@NotNull AntigriefIntegration antigrief) {
        REGISTRY.register(antigrief);
    }

    public static void unregister(@NotNull AntigriefIntegration antigrief) {
        REGISTRY.remove(antigrief);
    }

    public static boolean canPickupItem(@NotNull Player player, @NotNull Location location) {
        return REGISTRY.allSafely(integration -> integration.canPickupItem(player, location));
    }

    public static boolean canBreakBlock(@NotNull Player player, @NotNull Block block) {
        return REGISTRY.allSafely(integration -> integration.canBreakBlock(player, block));
    }

    public static boolean canCreateExplosion(@NotNull Player player, @NotNull Location location) {
        return REGISTRY.allSafely(integration -> integration.canCreateExplosion(player, location));
    }

    public static boolean canPlaceBlock(@NotNull Player player, @NotNull Block block) {
        return REGISTRY.allSafely(integration -> integration.canPlaceBlock(player, block));
    }

    public static boolean canInjure(@NotNull Player player, @NotNull LivingEntity victim) {
        return REGISTRY.allSafely(integration -> integration.canInjure(player, victim));
    }

    private AntigriefManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

