/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.items;

import com.willfp.eco.core.Eco;
import com.willfp.eco.core.items.Items;
import com.willfp.eco.core.items.TestableItem;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.function.Predicate;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;

public class CustomItem
implements TestableItem {
    private final NamespacedKey key;
    private final Predicate<@NotNull ItemStack> test;
    private final ItemStack item;

    public CustomItem(@NotNull NamespacedKey key, @NotNull @NotNull Predicate<@NotNull ItemStack> test, @NotNull ItemStack item) {
        this.key = key;
        this.test = test;
        this.item = item;
        Eco.get().getEcoPlugin().getScheduler().runLater(() -> {
            if (!this.matches(this.getItem())) {
                Eco.get().getEcoPlugin().getLogger().severe("Item with key " + key + " is invalid!");
            }
        }, 1L);
    }

    @Override
    public boolean matches(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        return this.test.test(itemStack);
    }

    @Override
    public ItemStack getItem() {
        return this.item.clone();
    }

    public void register() {
        Items.registerCustomItem(this.getKey(), this);
    }

    public NamespacedKey getKey() {
        return this.key;
    }
}

