/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.lookup;

import com.willfp.eco.core.lookup.LookupHandler;
import com.willfp.eco.core.lookup.Testable;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import com.willfp.eco.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class SegmentParser {
    private static final List<SegmentParser> REGISTERED = new ArrayList<SegmentParser>();
    private final String pattern;

    protected SegmentParser(@NotNull String pattern) {
        this.pattern = pattern;
    }

    public SegmentParser register() {
        REGISTERED.add(this);
        return this;
    }

    @Nullable
    public <T extends Testable<?>> T parse(@NotNull String key, @NotNull LookupHandler<T> handler) {
        if (!key.contains(" " + this.pattern + " ")) {
            return null;
        }
        String[] segments = StringUtils.splitAround(key, this.pattern);
        return this.handleSegments(segments, handler);
    }

    protected abstract <T extends Testable<?>> T handleSegments(@NotNull String[] var1, @NotNull LookupHandler<T> var2);

    public static Collection<SegmentParser> values() {
        return new ArrayList<SegmentParser>(REGISTERED);
    }
}

