/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.map;

import com.willfp.eco.core.map.ListMap;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class DefaultMap<K, V>
implements Map<K, V> {
    private final Map<K, V> map;
    private final Supplier<V> defaultValue;

    public DefaultMap(@NotNull V defaultValue) {
        this(() -> defaultValue);
    }

    public DefaultMap(@NotNull Supplier<V> defaultValue) {
        this((Map<K, V>)new HashMap(), defaultValue);
    }

    public DefaultMap(@NotNull Map<K, V> map2, @NotNull V defaultValue) {
        this(map2, () -> defaultValue);
    }

    public DefaultMap(@NotNull Map<K, V> map2, @NotNull Supplier<V> defaultValue) {
        this.map = map2;
        this.defaultValue = defaultValue;
    }

    @Override
    @NotNull
    public V get(@Nullable Object key) {
        if (key == null) {
            return this.defaultValue.get();
        }
        if (this.map.get(key) == null) {
            this.map.put(key, this.defaultValue.get());
        }
        return this.map.get(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V put(@NotNull K key, @Nullable V value) {
        return this.map.put(key, value);
    }

    @Override
    public V remove(@NotNull Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m4) {
        this.map.putAll(m4);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @NotNull
    public static <K, K1, V> DefaultMap<K, Map<K1, V>> createNestedMap() {
        return new DefaultMap<K, Map>(HashMap::new);
    }

    @NotNull
    public static <K, K1, V> DefaultMap<K, ListMap<K1, V>> createNestedListMap() {
        return new DefaultMap<K, ListMap>(ListMap::new);
    }
}

