/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.particle;

import com.willfp.eco.core.particle.ParticleFactory;
import com.willfp.eco.core.particle.SpawnableParticle;
import com.willfp.eco.core.particle.impl.EmptyParticle;
import com.willfp.eco.core.particle.impl.SimpleParticle;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.util.StringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Particle;

public final class Particles {
    private static final Map<String, ParticleFactory> FACTORIES = new ConcurrentHashMap<String, ParticleFactory>();

    public static void registerParticleFactory(@NotNull ParticleFactory factory) {
        for (String name : factory.getNames()) {
            FACTORIES.put(name.toLowerCase(), factory);
        }
    }

    @NotNull
    public static SpawnableParticle lookup(@NotNull String key) {
        SpawnableParticle spawnableParticle;
        String[] args2 = StringUtils.parseTokens(key.toLowerCase());
        if (args2.length == 0) {
            return new EmptyParticle();
        }
        String[] split = args2[0].split(":");
        if (split.length == 1) {
            try {
                Particle particle = Particle.valueOf((String)args2[0].toUpperCase());
                spawnableParticle = new SimpleParticle(particle);
            }
            catch (IllegalArgumentException e) {
                spawnableParticle = new EmptyParticle();
            }
        } else if (split.length == 2) {
            String name = split[0];
            String factoryKey = split[1];
            ParticleFactory factory = FACTORIES.get(name);
            spawnableParticle = factory == null ? new EmptyParticle() : factory.create(factoryKey);
        } else {
            return new EmptyParticle();
        }
        if (spawnableParticle == null || spawnableParticle instanceof EmptyParticle) {
            return new EmptyParticle();
        }
        return spawnableParticle;
    }

    private Particles() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

