/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.placeholder;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.placeholder.RegistrablePlaceholder;
import com.willfp.eco.core.placeholder.context.PlaceholderContext;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;

public final class DynamicPlaceholder
implements RegistrablePlaceholder {
    private final Pattern pattern;
    private final Function<@NotNull String, @Nullable String> function;
    private final EcoPlugin plugin;

    public DynamicPlaceholder(@NotNull EcoPlugin plugin, @NotNull Pattern pattern, @NotNull @NotNull Function<@NotNull String, @Nullable String> function) {
        this.plugin = plugin;
        this.pattern = pattern;
        this.function = function;
    }

    @Override
    @Nullable
    public String getValue(@NotNull String args2, @NotNull PlaceholderContext context) {
        return this.function.apply(args2);
    }

    @Deprecated(since="6.56.0", forRemoval=true)
    @NotNull
    public String getValue(@NotNull String args2) {
        return Objects.requireNonNullElse(this.function.apply(args2), "");
    }

    @Override
    @NotNull
    public EcoPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    @NotNull
    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    @NotNull
    public DynamicPlaceholder register() {
        return (DynamicPlaceholder)RegistrablePlaceholder.super.register();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DynamicPlaceholder)) {
            return false;
        }
        DynamicPlaceholder that = (DynamicPlaceholder)o;
        return Objects.equals(this.getPattern(), that.getPattern()) && Objects.equals(this.getPlugin(), that.getPlugin());
    }

    public int hashCode() {
        return Objects.hash(this.getPattern(), this.getPlugin());
    }
}

